

<?php $__env->startSection('title', trans('messages.promissory_notes')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $isRTL = app()->getLocale() === 'ar';
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.promissory_notes')); ?></h2>
    <div>
        <a href="<?php echo e(route('promissory-notes.create')); ?>" class="btn btn-primary"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_promissory_note')); ?></a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('promissory-notes.index')); ?>" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <select name="type" class="form-select">
                        <option value=""><?php echo e(trans('messages.all')); ?></option>
                        <option value="customer" <?php echo e(request('type') === 'customer' ? 'selected' : ''); ?>><?php echo e(trans('messages.customers')); ?></option>
                        <option value="supplier" <?php echo e(request('type') === 'supplier' ? 'selected' : ''); ?>><?php echo e(trans('messages.suppliers')); ?></option>
                    </select>
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_status')); ?></option>
                        <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>><?php echo e(trans('messages.pending')); ?></option>
                        <option value="due" <?php echo e(request('status') === 'due' ? 'selected' : ''); ?>><?php echo e(trans('messages.due')); ?></option>
                        <option value="paid" <?php echo e(request('status') === 'paid' ? 'selected' : ''); ?>><?php echo e(trans('messages.paid')); ?></option>
                        <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>><?php echo e(trans('messages.cancelled')); ?></option>
                    </select>
                </div>
                <?php if($customers->count() > 0): ?>
                <div class="col-md-2">
                    <select name="customer_id" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_customers')); ?></option>
                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($customer->id); ?>" <?php echo e(request('customer_id') == $customer->id ? 'selected' : ''); ?>><?php echo e($customer->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php endif; ?>
                <?php if($suppliers->count() > 0): ?>
                <div class="col-md-2">
                    <select name="supplier_id" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_suppliers')); ?></option>
                        <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($supplier->id); ?>" <?php echo e(request('supplier_id') == $supplier->id ? 'selected' : ''); ?>><?php echo e($supplier->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php endif; ?>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100"><?php echo e(trans('messages.search')); ?></button>
                </div>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th><?php echo e(trans('messages.note_number')); ?></th>
                        <th><?php echo e(trans('messages.type')); ?></th>
                        <th><?php echo e(trans('messages.name')); ?></th>
                        <th><?php echo e(trans('messages.amount')); ?></th>
                        <th><?php echo e(trans('messages.issue_date')); ?></th>
                        <th><?php echo e(trans('messages.due_date')); ?></th>
                        <th><?php echo e(trans('messages.status')); ?></th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $promissoryNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><strong><?php echo e($note->note_number); ?></strong></td>
                        <td>
                            <span class="badge bg-<?php echo e($note->type === 'customer' ? 'info' : 'warning'); ?>">
                                <?php echo e($note->type === 'customer' ? trans('messages.customers') : trans('messages.suppliers')); ?>

                            </span>
                        </td>
                        <td>
                            <?php if($note->type === 'customer'): ?>
                                <a href="<?php echo e(route('customers.show', $note->customer_id)); ?>"><?php echo e($note->customer->name ?? 'N/A'); ?></a>
                            <?php else: ?>
                                <a href="<?php echo e(route('suppliers.edit', $note->supplier_id)); ?>"><?php echo e($note->supplier->name ?? 'N/A'); ?></a>
                            <?php endif; ?>
                        </td>
                        <td><strong><?php echo e(format_currency($note->amount)); ?></strong></td>
                        <td><?php echo e($note->issue_date->format('Y-m-d')); ?></td>
                        <td>
                            <span class="<?php echo e($note->due_date < now() && !$note->isPaid() ? 'text-danger' : ''); ?>">
                                <?php echo e($note->due_date->format('Y-m-d')); ?>

                            </span>
                        </td>
                        <td>
                            <?php
                                $badgeClass = match($note->status) {
                                    'paid' => 'success',
                                    'due' => 'warning',
                                    'cancelled' => 'secondary',
                                    default => 'info'
                                };
                            ?>
                            <span class="badge bg-<?php echo e($badgeClass); ?>"><?php echo e(trans('messages.' . $note->status)); ?></span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('promissory-notes.show', $note)); ?>" class="btn btn-sm btn-info" title="<?php echo e(trans('messages.view')); ?>"><i class="bi bi-eye"></i></a>
                            <?php if(!$note->isPaid()): ?>
                                <a href="<?php echo e(route('promissory-notes.edit', $note)); ?>" class="btn btn-sm btn-warning" title="<?php echo e(trans('messages.edit')); ?>"><i class="bi bi-pencil"></i></a>
                            <?php endif; ?>
                            <?php if(!$note->isPaid()): ?>
                                <form action="<?php echo e(route('promissory-notes.destroy', $note)); ?>" method="POST" class="d-inline delete-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" title="<?php echo e(trans('messages.delete')); ?>"><i class="bi bi-trash"></i></button>
                                </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="8" class="text-center"><?php echo e(trans('messages.no_promissory_notes_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e($promissoryNotes->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/promissory-notes/index.blade.php ENDPATH**/ ?>