<?php $__env->startSection('title', trans('messages.categories')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
?>
<div class="page-header">
    <h2><?php echo e(trans('messages.categories')); ?></h2>
    <div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.import')): ?>
            <a href="<?php echo e(route('categories.import')); ?>" class="btn btn-success"><i class="bi bi-upload"></i> <?php echo e(trans('messages.import_categories')); ?></a>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.create')): ?>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createModal"><i class="bi bi-plus-circle"></i> <?php echo e(trans('messages.add_category')); ?></button>
        <?php endif; ?>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.bulk_delete')): ?>
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled data-bs-toggle="modal" data-bs-target="#bulkDeleteModal">
                <i class="bi bi-trash"></i> <?php echo e(trans('messages.delete_selected')); ?>

            </button>
        </div>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="table table-hover">
                    <thead>
                        <tr>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.bulk_delete')): ?>
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="<?php echo e(trans('messages.select_all')); ?>">
                            </th>
                            <?php endif; ?>
                            <th>
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'name', 'direction' => ($sort === 'name' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                    <?php echo e(trans('messages.name')); ?>

                                    <?php if($sort === 'name'): ?>
                                        <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php else: ?>
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th><?php echo e(trans('messages.name_ar')); ?></th>
                            <th>
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'products_count', 'direction' => ($sort === 'products_count' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                    <?php echo e(trans('messages.products')); ?> <?php echo e(trans('messages.quantity')); ?>

                                    <?php if($sort === 'products_count'): ?>
                                        <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php else: ?>
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th>
                                <a href="<?php echo e(request()->fullUrlWithQuery(['sort' => 'created_at', 'direction' => ($sort === 'created_at' && $direction === 'asc') ? 'desc' : 'asc'])); ?>" class="text-decoration-none text-dark">
                                    <?php echo e(trans('messages.date')); ?>

                                    <?php if($sort === 'created_at'): ?>
                                        <i class="bi bi-arrow-<?php echo e($direction === 'asc' ? 'up' : 'down'); ?>"></i>
                                    <?php else: ?>
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    <?php endif; ?>
                                </a>
                            </th>
                            <th><?php echo e(trans('messages.actions')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.bulk_delete')): ?>
                            <td>
                                <input type="checkbox" class="item-checkbox" value="<?php echo e($category->id); ?>">
                            </td>
                            <?php endif; ?>
                            <td><?php echo e($category->name); ?></td>
                            <td><?php echo e($category->name_ar ?? 'N/A'); ?></td>
                            <td><?php echo e($category->products_count); ?></td>
                            <td><?php echo e($category->created_at->format('Y-m-d')); ?></td>
                            <td>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.update')): ?>
                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($category->id); ?>" title="<?php echo e(trans('messages.edit')); ?>"><i class="bi bi-pencil"></i></button>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories.delete')): ?>
                                    <form action="<?php echo e(route('categories.destroy', $category)); ?>" method="POST" class="d-inline delete-form">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-danger" title="<?php echo e(trans('messages.delete')); ?>" onclick="event.preventDefault(); confirmAction('<?php echo e(trans('messages.confirm_delete_category')); ?>', '<?php echo e(trans('messages.confirm_delete')); ?>', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                    </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="<?php echo e(auth()->user()->can('categories.bulk_delete') ? '6' : '5'); ?>" class="text-center"><?php echo e(trans('messages.no_categories_found')); ?></td>
                        </tr>
                        <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Hidden form for bulk delete -->
        <form id="bulk-delete-form" method="POST" action="<?php echo e(route('categories.bulk_delete')); ?>" style="display: none;">
            <?php echo csrf_field(); ?>
        </form>

        <?php echo e($categories->links()); ?>

    </div>
</div>

<?php echo $__env->make('partials.bulk-delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Create Modal -->
<div class="modal fade" id="createModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="<?php echo e(route('categories.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(trans('messages.create_category')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name" class="form-label"><?php echo e(trans('messages.name')); ?> *</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="name_ar" class="form-label"><?php echo e(trans('messages.name_ar')); ?></label>
                        <input type="text" class="form-control" id="name_ar" name="name_ar">
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label"><?php echo e(trans('messages.description')); ?></label>
                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(trans('messages.create')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Modals -->
<?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editModal<?php echo e($category->id); ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="<?php echo e(route('categories.update', $category)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(trans('messages.edit_category')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name<?php echo e($category->id); ?>" class="form-label"><?php echo e(trans('messages.name')); ?> *</label>
                        <input type="text" class="form-control" id="name<?php echo e($category->id); ?>" name="name" value="<?php echo e($category->name); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="name_ar<?php echo e($category->id); ?>" class="form-label"><?php echo e(trans('messages.name_ar')); ?></label>
                        <input type="text" class="form-control" id="name_ar<?php echo e($category->id); ?>" name="name_ar" value="<?php echo e($category->name_ar); ?>">
                    </div>
                    <div class="mb-3">
                        <label for="description<?php echo e($category->id); ?>" class="form-label"><?php echo e(trans('messages.description')); ?></label>
                        <textarea class="form-control" id="description<?php echo e($category->id); ?>" name="description" rows="3"><?php echo e($category->description); ?></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(trans('messages.update')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/categories/index.blade.php ENDPATH**/ ?>