<?php $__env->startSection('title', trans('messages.pos')); ?>

<?php $__env->startSection('content'); ?>
<?php
    $isRTL = app()->getLocale() === 'ar';
    $allowNegativeStock = \App\Models\Setting::get('allow_negative_stock', '0') === '1';
    
    // Get warehouse ID if multiple warehouses mode
    $warehouseId = null;
    if (\App\Services\StockManager::isMultipleWarehouses()) {
        $warehouseId = \App\Services\StockManager::getDefaultWarehouse()?->id;
    }
    
    $cartTotals = $cartTotals ?? ['subtotal' => 0, 'tax' => 0, 'total' => 0, 'discount' => 0];
    $cartDiscount = $cartDiscount ?? ['type' => 'fixed', 'value' => 0];
?>

<div class="row g-3 pos-container">
    <!-- Categories Sidebar -->
    <div class="col-md-2 col-12 pos-categories-sidebar">
        <div class="card mb-2">
            <div class="card-header bg-dark text-white">
                <h5 class="mb-0"><?php echo e(trans('messages.categories')); ?></h5>
            </div>
            <div class="card-body p-2" id="categories-list" style="max-height: 300px; overflow-y: auto;">
                <button type="button" class="btn btn-sm w-100 mb-2 category-btn <?php echo e(!$selectedCategory ? 'btn-primary' : 'btn-outline-secondary'); ?>" 
                        data-category-id="">
                    <?php echo e(trans('messages.all_products')); ?>

                </button>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button type="button" class="btn btn-sm w-100 mb-2 category-btn <?php echo e($selectedCategory == $category->id ? 'btn-primary' : 'btn-outline-secondary'); ?>" 
                        data-category-id="<?php echo e($category->id); ?>">
                    <?php echo e(app()->getLocale() === 'ar' && $category->name_ar ? $category->name_ar : $category->name); ?>

                </button>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
        
        <!-- Quick Sales -->
        <div class="card">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0"><?php echo e(trans('messages.quick_sales')); ?></h6>
            </div>
            <div class="card-body p-2">
                <button type="button" class="btn btn-sm btn-outline-primary w-100 mb-2" id="show-favorites-btn">
                    <i class="bi bi-star"></i> <?php echo e(trans('messages.favorites')); ?>

                </button>
                <button type="button" class="btn btn-sm btn-outline-success w-100 mb-2" id="show-recent-btn">
                    <i class="bi bi-clock-history"></i> <?php echo e(trans('messages.recently_sold')); ?>

                </button>
            </div>
        </div>
    </div>

    <!-- Products Grid -->
    <div class="col-md-7 col-12 pos-products-grid">
        <div class="card">
            <div class="card-header bg-dark text-white">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <h5 class="mb-0"><?php echo e(trans('messages.products')); ?></h5>
                    <div class="d-flex gap-2 align-items-center">
                        <button type="button" class="btn btn-sm btn-outline-light" id="shortcut-help-btn" title="<?php echo e(trans('messages.keyboard_shortcuts')); ?>">
                            <i class="bi bi-keyboard"></i>
                        </button>
                        <button type="button" class="btn btn-sm btn-outline-light" id="offline-toggle-btn" title="<?php echo e(trans('messages.online_mode')); ?>">
                            <i class="bi bi-wifi"></i> <span id="connection-status"><?php echo e(trans('messages.online_mode')); ?></span>
                        </button>
                    </div>
                </div>
                <div class="d-flex gap-2">
                    <?php if($selectedCategory): ?>
                        <input type="hidden" id="selected-category" value="<?php echo e($selectedCategory); ?>">
                    <?php endif; ?>
                    <div class="position-relative flex-grow-1">
                        <input type="text" id="barcode-input" class="form-control form-control-sm" 
                               placeholder="<?php echo e(trans('messages.scan_barcode')); ?>..." 
                               autocomplete="off" style="width: 100%;">
                        <span class="position-absolute top-50 translate-middle-y <?php echo e($isRTL ? 'start-0' : 'end-0'); ?> pe-2" style="pointer-events: none;">
                            <i class="bi bi-upc-scan text-muted"></i>
                        </span>
                    </div>
                    <div class="position-relative" style="width: 250px;">
                        <input type="text" id="pos-search-input" class="form-control form-control-sm" 
                               placeholder="<?php echo e(trans('messages.search')); ?>..." 
                               value="<?php echo e(request('search')); ?>" style="width: 100%;">
                        <span class="position-absolute top-50 translate-middle-y <?php echo e($isRTL ? 'start-0' : 'end-0'); ?> pe-2" style="pointer-events: none;">
                            <i class="bi bi-search text-muted"></i>
                        </span>
                    </div>
                    <button type="button" id="clear-search-btn" class="btn btn-sm btn-outline-secondary" style="display: none;">
                        <i class="bi bi-x"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div id="products-loading" class="text-center py-4" style="display: none;">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden"><?php echo e(trans('messages.loading')); ?>...</span>
                    </div>
                </div>
                <div id="products-container">
                    <div class="row g-3" id="products-grid">
                        <?php echo $__env->make('pos.partials.products-grid', ['products' => $products, 'posSettings' => $posSettings, 'allowNegativeStock' => $allowNegativeStock, 'warehouseId' => $warehouseId, 'isRTL' => $isRTL], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    
                    <!-- Pagination (only shown when not searching) -->
                    <div id="products-pagination" class="mt-3">
                        <?php if($products->hasPages() && !request('search')): ?>
                            <?php echo e($products->links()); ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Cart Sidebar -->
    <div class="col-md-3 col-12 pos-cart-sidebar">
        <div class="card sticky-top pos-cart-sticky" style="top: 80px;">
            <div class="card-header bg-dark text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><?php echo e(trans('messages.cart')); ?></h5>
                <span class="badge bg-primary" id="cart-count"><?php echo e(count($cart)); ?></span>
            </div>
            <div class="card-body p-2" style="max-height: 500px; overflow-y: auto;">
                <div id="cart-items">
                    <?php $__empty_1 = true; $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="card mb-2 cart-item" data-product-id="<?php echo e($item['product_id']); ?>">
                        <div class="card-body p-2">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h6 class="mb-0"><?php echo e(app()->getLocale() === 'ar' && isset($item['name_ar']) && $item['name_ar'] ? $item['name_ar'] : $item['name']); ?></h6>
                                <button class="btn btn-sm btn-danger remove-from-cart-btn" data-product-id="<?php echo e($item['product_id']); ?>" title="<?php echo e(trans('messages.remove')); ?>">
                                    <i class="bi bi-x"></i>
                                </button>
                            </div>
                            <div class="input-group input-group-sm mb-2">
                                <span class="input-group-text"><?php echo e(trans('messages.quantity')); ?></span>
                                <input type="number" class="form-control cart-quantity" 
                                       data-product-id="<?php echo e($item['product_id']); ?>"
                                       value="<?php echo e($item['quantity']); ?>" min="1">
                            </div>
                            <div class="input-group input-group-sm mb-2">
                                <span class="input-group-text"><?php echo e(trans('messages.price')); ?></span>
                                <input type="number" class="form-control cart-price" 
                                       data-product-id="<?php echo e($item['product_id']); ?>"
                                       value="<?php echo e($item['unit_price']); ?>" min="0" step="0.01">
                                <button class="btn btn-sm btn-outline-secondary edit-price-btn" data-product-id="<?php echo e($item['product_id']); ?>" title="<?php echo e(trans('messages.edit_price')); ?>">
                                    <i class="bi bi-pencil"></i>
                                </button>
                            </div>
                            <?php if(($item['discount'] ?? 0) > 0): ?>
                            <div class="mb-2">
                                <small class="text-success">
                                    <i class="bi bi-tag"></i> <?php echo e(trans('messages.discount')); ?>: <?php echo e(format_currency($item['discount'])); ?>

                                </small>
                            </div>
                            <?php endif; ?>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <small class="text-muted"><?php echo e(format_currency($item['unit_price'])); ?> x <?php echo e($item['quantity']); ?></small>
                                <strong class="cart-item-total"><?php echo e(format_currency($item['subtotal'] ?? ($item['unit_price'] * $item['quantity']))); ?></strong>
                            </div>
                            <div class="d-flex gap-1">
                                <button class="btn btn-sm btn-outline-warning flex-fill item-discount-btn" data-product-id="<?php echo e($item['product_id']); ?>" title="<?php echo e(trans('messages.apply_discount')); ?>">
                                    <i class="bi bi-percent"></i> <?php echo e(trans('messages.discount')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-center text-muted"><?php echo e(trans('messages.cart_is_empty')); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-footer">
                <!-- Cart Summary -->
                <div class="mb-2">
                    <div class="d-flex justify-content-between mb-1">
                        <small><?php echo e(trans('messages.subtotal')); ?>:</small>
                        <small id="cart-subtotal"><?php echo e(format_currency($cartTotals['subtotal'])); ?></small>
                    </div>
                    <?php if(($cartDiscount['value'] ?? 0) > 0): ?>
                    <div class="d-flex justify-content-between mb-1">
                        <small class="text-success"><?php echo e(trans('messages.discount')); ?>:</small>
                        <small class="text-success" id="cart-discount-display">-<?php echo e(format_currency($cartTotals['discount'])); ?></small>
                    </div>
                    <?php endif; ?>
                    <div class="d-flex justify-content-between mb-1">
                        <small><?php echo e(trans('messages.tax')); ?>:</small>
                        <small id="cart-tax"><?php echo e(format_currency($cartTotals['tax'])); ?></small>
                    </div>
                    <hr class="my-2">
                    <div class="d-flex justify-content-between mb-2">
                    <strong><?php echo e(trans('messages.total')); ?>:</strong>
                        <strong id="cart-total"><?php echo e(format_currency($cartTotals['total'])); ?></strong>
                </div>
                </div>
                
                <!-- Discount Button -->
                <button class="btn btn-sm btn-outline-warning w-100 mb-2" id="cart-discount-btn" <?php echo e(empty($cart) ? 'disabled' : ''); ?>>
                    <i class="bi bi-tag"></i> <?php echo e(trans('messages.apply_discount')); ?>

                </button>
                
                <!-- Customer Selection -->
                    <div class="mb-2">
                    <div class="position-relative">
                        <input type="text" class="form-control form-control-sm" id="customer-search-input" 
                               placeholder="<?php echo e(trans('messages.search_customer')); ?>..." autocomplete="off">
                        <div id="customer-search-results" class="position-absolute w-100 bg-white border rounded shadow-lg" style="z-index: 1000; display: none; max-height: 200px; overflow-y: auto; top: 100%;"></div>
                    </div>
                    <input type="hidden" name="customer_id" id="selected-customer-id" value="">
                    <div id="selected-customer-info" class="mt-2 p-2 bg-light rounded">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <strong id="selected-customer-name"><?php echo e(trans('messages.walk_in_customer')); ?></strong>
                                <br><small class="text-muted" id="selected-customer-balance">0.00 <?php echo e(currency_symbol()); ?></small>
                            </div>
                            <button type="button" class="btn btn-sm btn-outline-danger" id="clear-customer-btn" style="display: none;">
                                <i class="bi bi-x"></i>
                            </button>
                        </div>
                    </div>
                    <button type="button" class="btn btn-sm btn-outline-primary w-100 mt-1" id="quick-add-customer-btn">
                        <i class="bi bi-person-plus"></i> <?php echo e(trans('messages.add_customer')); ?>

                    </button>
                </div>
                
                <!-- Action Buttons -->
                <?php if($posSettings['enable_payment'] ?? false): ?>
                    <button type="button" class="btn btn-success w-100 mb-2" id="process-payment-btn" <?php echo e(empty($cart) ? 'disabled' : ''); ?>>
                        <i class="bi bi-credit-card"></i> <?php echo e(trans('messages.process_payment')); ?>

                    </button>
                <?php endif; ?>
                <button type="button" class="btn <?php echo e(($posSettings['enable_payment'] ?? false) ? 'btn-outline-success' : 'btn-success'); ?> w-100 mb-2" id="create-invoice-btn" <?php echo e(empty($cart) ? 'disabled' : ''); ?>>
                        <i class="bi bi-receipt"></i> <?php echo e(trans('messages.create_invoice')); ?>

                    </button>
                <div class="btn-group w-100 mb-2" role="group">
                    <button type="button" class="btn btn-outline-secondary" id="save-draft-btn" <?php echo e(empty($cart) ? 'disabled' : ''); ?>>
                        <i class="bi bi-save"></i> <?php echo e(trans('messages.save_draft')); ?>

                    </button>
                </div>
                <div class="btn-group w-100 mb-2" role="group">
                    <a href="<?php echo e(route('pos.print-ticket')); ?>" target="_blank" 
                       class="btn btn-outline-primary <?php echo e(empty($cart) ? 'disabled' : ''); ?>" 
                       id="print-ticket-btn"
                       onclick="if($(this).hasClass('disabled')) { event.preventDefault(); return false; }">
                        <i class="bi bi-printer"></i> <?php echo e(trans('messages.print')); ?>

                    </a>
                    <button type="button" class="btn btn-outline-danger" id="clear-cart-btn" <?php echo e(empty($cart) ? 'disabled' : ''); ?>>
                        <i class="bi bi-trash"></i> <?php echo e(trans('messages.clear')); ?>

                </button>
            </div>
                
                <!-- Today Stats -->
                <div class="mt-3 p-2 bg-info bg-opacity-10 rounded">
                    <small class="d-block text-center"><strong><?php echo e(trans('messages.today_stats')); ?></strong></small>
                    <div class="d-flex justify-content-between mt-1">
                        <small><?php echo e(trans('messages.total_sales')); ?>:</small>
                        <small id="today-total-sales">0.00</small>
                    </div>
                    <div class="d-flex justify-content-between">
                        <small><?php echo e(trans('messages.invoices')); ?>:</small>
                        <small id="today-invoice-count">0</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Toast Notification -->
<div class="toast-container position-fixed <?php echo e($isRTL ? 'start-0' : 'end-0'); ?> p-3" style="z-index: 10000; bottom: 80px;">
    <div id="toast-notification" class="toast" role="alert">
        <div class="toast-header">
            <strong class="me-auto"><?php echo e(trans('messages.notification')); ?></strong>
            <button type="button" class="btn-close" data-bs-dismiss="toast"></button>
        </div>
        <div class="toast-body" id="toast-message"></div>
    </div>
</div>

<!-- Keyboard Shortcuts Modal -->
<div class="modal fade" id="shortcut-help-modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(trans('messages.keyboard_shortcuts')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <table class="table table-sm">
                    <tr>
                        <td><kbd>/</kbd></td>
                        <td><strong><?php echo e(trans('messages.shortcut_search')); ?></strong></td>
                    </tr>
                    <tr>
                        <td><kbd>Ctrl</kbd> + <kbd>B</kbd></td>
                        <td><strong><?php echo e(trans('messages.shortcut_focus_barcode')); ?></strong></td>
                    </tr>
                    <tr>
                        <td><kbd>Enter</kbd></td>
                        <td><strong><?php echo e(trans('messages.shortcut_add_to_cart')); ?></strong></td>
                    </tr>
                    <tr>
                        <td><kbd>Ctrl</kbd> + <kbd>Enter</kbd></td>
                        <td><strong><?php echo e(trans('messages.shortcut_create_invoice')); ?></strong></td>
                    </tr>
                    <tr>
                        <td><kbd>Ctrl</kbd> + <kbd>D</kbd></td>
                        <td><strong><?php echo e(trans('messages.shortcut_discount')); ?></strong></td>
                    </tr>
                    <tr>
                        <td><kbd>Ctrl</kbd> + <kbd>T</kbd></td>
                        <td><strong><?php echo e(trans('messages.shortcut_tax')); ?></strong></td>
                    </tr>
                    <tr>
                        <td><kbd>Ctrl</kbd> + <kbd>P</kbd></td>
                        <td><strong><?php echo e(trans('messages.shortcut_print_receipt')); ?></strong></td>
                    </tr>
                    <tr>
                        <td><kbd>Delete</kbd></td>
                        <td><strong><?php echo e(trans('messages.shortcut_clear_cart')); ?></strong></td>
                    </tr>
                    <tr>
                        <td><kbd>F11</kbd></td>
                        <td><strong><?php echo e(trans('messages.shortcut_fullscreen')); ?></strong></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Confirmation Modal -->
<div class="modal fade" id="confirm-modal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true" style="z-index: 1060;">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title" id="confirmModalLabel">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i><?php echo e(trans('messages.confirm')); ?>

                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p id="confirm-message" class="mb-0"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="bi bi-x-circle me-1"></i><?php echo e(trans('messages.cancel')); ?>

                </button>
                <button type="button" class="btn btn-primary" id="confirm-ok-btn">
                    <i class="bi bi-check-circle me-1"></i><?php echo e(trans('messages.confirm')); ?>

                </button>
            </div>
        </div>
    </div>
</div>

<!-- Cart Discount Modal -->
<div class="modal fade" id="cart-discount-modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(trans('messages.apply_discount')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label"><?php echo e(trans('messages.discount_type')); ?></label>
                    <select class="form-select" id="discount-type">
                        <option value="fixed"><?php echo e(trans('messages.fixed_amount')); ?></option>
                        <option value="percentage"><?php echo e(trans('messages.percentage')); ?></option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label"><?php echo e(trans('messages.discount_value')); ?></label>
                    <input type="number" class="form-control" id="discount-value" min="0" step="0.01" placeholder="0.00">
                    <small class="text-muted" id="discount-hint"></small>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                <button type="button" class="btn btn-primary" id="apply-cart-discount-btn"><?php echo e(trans('messages.apply')); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- Item Discount Modal -->
<div class="modal fade" id="item-discount-modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(trans('messages.apply_item_discount')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="item-discount-product-id">
                <div class="mb-3">
                    <label class="form-label"><?php echo e(trans('messages.product')); ?></label>
                    <input type="text" class="form-control" id="item-discount-product-name" readonly>
                </div>
                <div class="mb-3">
                    <label class="form-label"><?php echo e(trans('messages.discount_type')); ?></label>
                    <select class="form-select" id="item-discount-type">
                        <option value="fixed"><?php echo e(trans('messages.fixed_amount')); ?></option>
                        <option value="percentage"><?php echo e(trans('messages.percentage')); ?></option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label"><?php echo e(trans('messages.discount_value')); ?></label>
                    <input type="number" class="form-control" id="item-discount-value" min="0" step="0.01" placeholder="0.00">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                <button type="button" class="btn btn-primary" id="apply-item-discount-btn"><?php echo e(trans('messages.apply')); ?></button>
            </div>
        </div>
    </div>
</div>


<!-- Payment Modal -->
<?php if($posSettings['enable_payment'] ?? false): ?>
<div class="modal fade" id="payment-modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(trans('messages.process_payment')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label"><strong><?php echo e(trans('messages.total')); ?>:</strong></label>
                    <div class="h4 text-primary" id="payment-total">0.00 <?php echo e(currency_symbol()); ?></div>
                </div>
                <div class="mb-3">
                    <label class="form-label"><?php echo e(trans('messages.payment_method')); ?> *</label>
                    <select class="form-select" id="payment-method" required>
                        <option value="cash"><?php echo e(trans('messages.cash')); ?></option>
                        <option value="card"><?php echo e(trans('messages.card')); ?></option>
                        <option value="bank_transfer"><?php echo e(trans('messages.bank_transfer')); ?></option>
                        <option value="cheque"><?php echo e(trans('messages.cheque')); ?></option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label"><?php echo e(trans('messages.amount')); ?> *</label>
                    <input type="number" class="form-control" id="payment-amount" min="0" step="0.01" placeholder="0.00" required>
                    <small class="text-muted"><?php echo e(trans('messages.enter_payment_amount')); ?></small>
                </div>
                <div class="mb-3" id="payment-change-container" style="display: none;">
                    <label class="form-label text-success"><strong><?php echo e(trans('messages.change')); ?>:</strong></label>
                    <div class="h5 text-success" id="payment-change">0.00 <?php echo e(currency_symbol()); ?></div>
                </div>
                <div class="mb-3">
                    <label class="form-label"><?php echo e(trans('messages.notes')); ?></label>
                    <textarea class="form-control" id="payment-notes" rows="2" placeholder="<?php echo e(trans('messages.payment_notes_optional')); ?>"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                <button type="button" class="btn btn-success" id="confirm-payment-btn">
                    <i class="bi bi-check-circle"></i> <?php echo e(trans('messages.confirm_payment')); ?>

                </button>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Quick Add Customer Modal -->
<div class="modal fade" id="quick-add-customer-modal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(trans('messages.add_customer')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="quick-add-customer-form">
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(trans('messages.name')); ?> <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(trans('messages.phone')); ?></label>
                        <input type="text" class="form-control" name="phone">
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?php echo e(trans('messages.email')); ?></label>
                        <input type="email" class="form-control" name="email">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                <button type="button" class="btn btn-primary" id="save-quick-customer-btn"><?php echo e(trans('messages.save')); ?></button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Initialize toast only if element exists
    let toast = null;
    const toastEl = document.getElementById('toast-notification');
    if (toastEl) {
        toast = new bootstrap.Toast(toastEl);
    }
    
    let searchTimeout;
    let currentCategoryId = '<?php echo e($selectedCategory ?? ''); ?>';
    let currentPage = 1;
    
    // Store current cart and discount in global variables for payment modal
    let currentCartData = <?php echo json_encode($cart, 15, 512) ?>;
    let currentCartDiscountData = <?php echo json_encode($cartDiscount, 15, 512) ?>;

    // Load products via AJAX
    function loadProducts(categoryId = '', page = 1, search = '') {
        // Show loading
        $('#products-loading').show();
        $('#products-grid').hide();
        $('#products-pagination').hide();
        
        // Update category buttons
        $('.category-btn').removeClass('btn-primary').addClass('btn-outline-secondary');
        if (categoryId) {
            $(`.category-btn[data-category-id="${categoryId}"]`).removeClass('btn-outline-secondary').addClass('btn-primary');
        } else {
            $(`.category-btn[data-category-id=""]`).removeClass('btn-outline-secondary').addClass('btn-primary');
        }
        
        // Update hidden input
        if (categoryId) {
            if ($('#selected-category').length) {
                $('#selected-category').val(categoryId);
            } else {
                $('<input>').attr({
                    type: 'hidden',
                    id: 'selected-category',
                    value: categoryId
                }).appendTo('.card-header');
            }
        } else {
            $('#selected-category').remove();
        }
        
        currentCategoryId = categoryId;
        currentPage = page;
        
        $.ajax({
            url: '<?php echo e(route('pos.products')); ?>',
            method: 'GET',
            data: {
                category_id: categoryId,
                page: page,
                search: search
            },
            success: function(response) {
                if (response.success) {
                    $('#products-grid').html(response.html);
                    $('#products-pagination').html(response.pagination);
                    $('#products-grid').show();
                    if (response.pagination) {
                        $('#products-pagination').show();
                    }
                }
            },
            error: function(xhr) {
                showToast('<?php echo e(trans('messages.error')); ?>', 'danger');
                $('#products-grid').show();
            },
            complete: function() {
                $('#products-loading').hide();
            }
        });
    }

    // Handle category button clicks
    $(document).on('click', '.category-btn', function(e) {
        e.preventDefault();
        const categoryId = $(this).data('category-id') || '';
        // Clear search when changing category
        $('#pos-search-input').val('');
        $('#clear-search-btn').hide();
        loadProducts(categoryId, 1, '');
    });

    // Handle pagination clicks (delegated event)
    $(document).on('click', '#products-pagination a', function(e) {
        e.preventDefault();
        const url = $(this).attr('href');
        if (url) {
            const urlObj = new URL(url);
            const page = urlObj.searchParams.get('page') || 1;
            const search = $('#pos-search-input').val().trim();
            loadProducts(currentCategoryId, page, search);
            // Scroll to top of products
            $('html, body').animate({
                scrollTop: $('#products-container').offset().top - 100
            }, 300);
        }
    });

    // Handle invoice creation button click
    // ========== PAYMENT PROCESSING ==========
    <?php if($posSettings['enable_payment'] ?? false): ?>
    $('#process-payment-btn').on('click', function() {
        if ($(this).prop('disabled')) {
            return;
        }
        
        // Get current total from displayed cart total (most reliable)
        // Extract number from text (handles currency symbols, commas, and formatting)
        const cartTotalText = $('#cart-total').text().trim();
        // Remove all non-numeric characters except digits, dots, and minus signs
        const displayedTotal = parseFloat(cartTotalText.replace(/[^\d.-]/g, '').replace(/,/g, '')) || 0;
        
        let totalToUse = displayedTotal;
        
        // If displayed total is 0 or invalid, try to calculate from current cart data
        if (!displayedTotal || displayedTotal <= 0 || isNaN(displayedTotal)) {
            const totals = calculateCartTotals(currentCartData, currentCartDiscountData);
            totalToUse = parseFloat(totals.total || 0);
        }
        
        // Ensure we have a valid number
        if (isNaN(totalToUse) || totalToUse < 0) {
            totalToUse = 0;
        }
        
        // Set total and payment amount
        $('#payment-total').text(totalToUse.toFixed(2) + ' <?php echo e(currency_symbol()); ?>');
        $('#payment-amount').val(totalToUse.toFixed(2));
        
        $('#payment-change-container').hide();
        $('#payment-change').text('0.00 <?php echo e(currency_symbol()); ?>');
        
        // Show payment modal
        const paymentModal = new bootstrap.Modal(document.getElementById('payment-modal'));
        paymentModal.show();
        
        // Focus on payment amount
        setTimeout(() => {
            $('#payment-amount').focus().select();
        }, 300);
    });
    
    // Calculate change when payment amount changes
    $('#payment-amount').on('input', function() {
        const total = parseFloat($('#payment-total').text().replace(/[^0-9.]/g, ''));
        const paid = parseFloat($(this).val()) || 0;
        const change = paid - total;
        
        if (change > 0) {
            $('#payment-change-container').show();
            $('#payment-change').text(parseFloat(change).toFixed(2) + ' <?php echo e(currency_symbol()); ?>');
        } else {
            $('#payment-change-container').hide();
            $('#payment-change').text('0.00 <?php echo e(currency_symbol()); ?>');
        }
    });
    
    // Extract payment processing to separate function (define before use)
    function processPaymentSubmission(paymentAmount, paymentMethod, paymentNotes, total) {
        const submitBtn = $('#confirm-payment-btn');
        const originalText = submitBtn.html();
        
        // Disable button and show loading
        submitBtn.prop('disabled', true).html('<i class="bi bi-hourglass-split"></i> <?php echo e(trans('messages.processing')); ?>...');
        
        // Get customer info
        const customerId = $('#selected-customer-id').val() || null;
        const customerName = $('#selected-customer-name').text() || '<?php echo e(trans('messages.walk_in_customer')); ?>';
        
        // Create invoice with payment
        $.ajax({
            url: '<?php echo e(route('pos.create-invoice')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                customer_id: customerId,
                customer_name: customerName,
                payment_amount: paymentAmount,
                payment_method: paymentMethod,
                payment_notes: paymentNotes
            },
            success: function(response) {
                if (response.success) {
                    showToast(response.message, 'success');
                    
                    // Close payment modal
                    const paymentModal = bootstrap.Modal.getInstance(document.getElementById('payment-modal'));
                    if (paymentModal) {
                        paymentModal.hide();
                    }
                    
                    // Clear cart
                    updateCartUI([], {subtotal: 0, tax: 0, total: 0, discount: 0}, 0);
                    
                    // Reset customer to walk-in
                    selectedCustomer = null;
                    $('#selected-customer-id').val('');
                    $('#selected-customer-name').text('<?php echo e(trans('messages.walk_in_customer')); ?>');
                    $('#selected-customer-balance').text('0.00 <?php echo e(currency_symbol()); ?>');
                    $('#clear-customer-btn').hide();
                    updatePrintTicketLink();
                    
                    // Open invoice page
                    if (response.show_url) {
                        window.open(response.show_url, '_blank');
                    }
                    
                    // Auto print if enabled
                    if (response.auto_print && response.print_url) {
                        setTimeout(() => {
                            window.open(response.print_url, '_blank');
                        }, 500);
                    }
                    
                    // Reload today stats
                    loadTodayStats();
                    
                    // Refresh page after a short delay to allow windows to open
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                } else {
                    showToast(response.message || '<?php echo e(trans('messages.error_processing_payment')); ?>', 'danger');
                    submitBtn.prop('disabled', false).html(originalText);
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error_processing_payment')); ?>';
                showToast(message, 'danger');
                submitBtn.prop('disabled', false).html(originalText);
            }
        });
    }
    
    // Confirm payment
    $('#confirm-payment-btn').on('click', function() {
        const paymentAmount = parseFloat($('#payment-amount').val());
        const paymentMethod = $('#payment-method').val();
        const paymentNotes = $('#payment-notes').val();
        const total = parseFloat($('#payment-total').text().replace(/[^0-9.]/g, ''));
        
        if (!paymentAmount || paymentAmount <= 0) {
            showToast('<?php echo e(trans('messages.invalid_payment_amount')); ?>', 'danger');
            return;
        }
        
        // Only show confirm if payment is less than total
        if (paymentAmount < total) {
            // Show confirm modal behind payment modal (higher z-index)
            showConfirm('<?php echo e(trans('messages.payment_less_than_total')); ?>', function(confirmed) {
                if (!confirmed) {
                    return;
                }
                // Continue with payment processing
                processPaymentSubmission(paymentAmount, paymentMethod, paymentNotes, total);
            });
            return;
        }
        
        // Process payment if amount is valid (no confirmation needed if payment equals or exceeds total)
        processPaymentSubmission(paymentAmount, paymentMethod, paymentNotes, total);
    });
    <?php endif; ?>
    
    $('#create-invoice-btn').on('click', function() {
        if ($(this).prop('disabled')) {
            return;
        }
        
        const submitBtn = $(this);
        const originalText = submitBtn.html();
        
        // Disable button and show loading
        submitBtn.prop('disabled', true).html('<i class="bi bi-hourglass-split"></i> <?php echo e(trans('messages.loading')); ?>...');
        
        const formData = {
            _token: '<?php echo e(csrf_token()); ?>',
            customer_id: selectedCustomer ? selectedCustomer.id : null,
            customer_name: selectedCustomer ? selectedCustomer.name : '<?php echo e(trans('messages.walk_in_customer')); ?>'
        };
        
        $.ajax({
            url: '<?php echo e(route('pos.create-invoice')); ?>',
            method: 'POST',
            data: formData,
            dataType: 'json',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            },
            success: function(response) {
                if (response.success) {
                    // Show success message
                    showToast(response.message, 'success');
                    
                    // Open invoice show page in new tab
                    try {
                        const showWindow = window.open(response.show_url, '_blank', 'noopener,noreferrer');
                        if (!showWindow || showWindow.closed || typeof showWindow.closed === 'undefined') {
                            console.warn('Show window blocked! Please allow popups for this site.');
                            // Don't redirect here, just log the warning
                        } else {
                            console.log('Invoice show window opened successfully');
                        }
                    } catch (e) {
                        console.error('Error opening invoice show window:', e);
                    }
                    
                    // Always open print page in new tab
                    let printUrl = response.print_url;
                    // Add auto_print parameter if enabled
                    if (response.auto_print) {
                        const separator = printUrl.includes('?') ? '&' : '?';
                        printUrl = printUrl + separator + 'auto_print=1';
                    }
                    console.log('Opening print page:', printUrl, 'Auto print:', response.auto_print);
                    
                    // Open print page in new tab (always open, not just when auto_print is enabled)
                    try {
                        const printWindow = window.open(printUrl, '_blank', 'noopener,noreferrer');
                        if (!printWindow || printWindow.closed || typeof printWindow.closed === 'undefined') {
                            console.warn('Print window blocked! Please allow popups for this site.');
                            showToast('<?php echo e(trans('messages.popup_blocked')); ?>', 'warning');
                        } else {
                            console.log('Print window opened successfully');
                        }
                    } catch (e) {
                        console.error('Error opening print window:', e);
                        showToast('<?php echo e(trans('messages.error_creating_invoice')); ?>', 'danger');
                    }
                    
                    // Clear cart and discount
                    $.ajax({
                        url: '<?php echo e(route('pos.cart.clear')); ?>',
                        method: 'POST',
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        success: function(response) {
                            if (response.success) {
                                cartDiscount = response.cart_discount;
                                updateCartUI(response.cart || {}, response.totals, response.cart_count);
                                
                                // Reset customer to walk-in
                                selectedCustomer = null;
                                $('#selected-customer-id').val('');
                                $('#selected-customer-name').text('<?php echo e(trans('messages.walk_in_customer')); ?>');
                                $('#selected-customer-balance').text('0.00 <?php echo e(currency_symbol()); ?>');
                                $('#clear-customer-btn').hide();
                                updatePrintTicketLink();
                            }
                        }
                    });
                    
                    // Refresh page after a short delay to allow windows to open
                    setTimeout(function() {
                        location.reload();
                    }, 1000);
                } else {
                    showToast(response.message || '<?php echo e(trans('messages.error_creating_invoice')); ?>', 'danger');
                    submitBtn.prop('disabled', false).html(originalText);
                }
            },
            error: function(xhr) {
                let message = '<?php echo e(trans('messages.error_creating_invoice')); ?>';
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    message = xhr.responseJSON.message;
                } else if (xhr.responseText) {
                    try {
                        const jsonResponse = JSON.parse(xhr.responseText);
                        if (jsonResponse.message) {
                            message = jsonResponse.message;
                        }
                    } catch (e) {
                        // Not JSON, use default message
                    }
                }
                showToast(message, 'danger');
                submitBtn.prop('disabled', false).html(originalText);
            }
        });
    });

    function showToast(message, type = 'success') {
        const toastMessageEl = $('#toast-message');
        const toastNotificationEl = $('#toast-notification');
        
        if (toastMessageEl.length) {
            toastMessageEl.text(message);
        }
        
        if (toastNotificationEl.length) {
            toastNotificationEl.removeClass('bg-success bg-danger text-white');
            if (type === 'success') {
                toastNotificationEl.addClass('bg-success text-white');
            } else {
                toastNotificationEl.addClass('bg-danger text-white');
            }
        }
        
        if (toast) {
            try {
                toast.show();
            } catch (e) {
                console.error('Error showing toast:', e);
                // Fallback to alert if toast fails
                alert(message);
            }
        } else {
            // Fallback to alert if toast is not available
            console.warn('Toast not initialized, using alert');
            alert(message);
        }
    }
    
    // Beautiful confirmation dialog using Bootstrap Modal
    function showConfirm(message, callback) {
        if (!message) {
            // Fallback to browser confirm
            const result = confirm(message || '<?php echo e(trans('messages.confirm')); ?>');
            if (callback && typeof callback === 'function') {
                callback(result);
            }
            return;
        }
        
        const confirmModalEl = document.getElementById('confirm-modal');
        if (!confirmModalEl) {
            // Fallback to browser confirm if modal doesn't exist
            const result = confirm(message);
            if (callback && typeof callback === 'function') {
                callback(result);
            }
            return;
        }
        
        // Set message
        const confirmMessageEl = $('#confirm-message');
        if (confirmMessageEl.length) {
            confirmMessageEl.text(message);
        }
        
        // Get or create modal instance
        let confirmModal;
        try {
            confirmModal = bootstrap.Modal.getOrCreateInstance(confirmModalEl);
        } catch (e) {
            console.error('Error creating modal:', e);
            // Fallback to browser confirm
            const result = confirm(message);
            if (callback && typeof callback === 'function') {
                callback(result);
            }
            return;
        }
        
        // Set z-index to appear above payment modal (Bootstrap default is 1055, we set 1060)
        $(confirmModalEl).css('z-index', '1060');
        // Update backdrop z-index if it exists
        setTimeout(function() {
            const backdrops = $('.modal-backdrop');
            if (backdrops.length > 0) {
                backdrops.last().css('z-index', '1059');
            }
        }, 100);
        
        // Remove previous event listeners
        $('#confirm-ok-btn').off('click.confirm');
        $('#confirm-modal').off('hidden.bs.modal.confirm');
        
        // Track if callback was called
        let callbackCalled = false;
        
        // Handle confirm button click
        $('#confirm-ok-btn').on('click.confirm', function() {
            callbackCalled = true;
            try {
                confirmModal.hide();
            } catch (e) {
                console.error('Error hiding modal:', e);
            }
            if (callback && typeof callback === 'function') {
                callback(true);
            }
        });
        
        // Handle cancel/close
        $('#confirm-modal').on('hidden.bs.modal.confirm', function() {
            if (!callbackCalled && callback && typeof callback === 'function') {
                callback(false);
            }
            callbackCalled = false;
            // Restore z-index after closing
            $(confirmModalEl).css('z-index', '');
        });
        
        // Show modal
        try {
            confirmModal.show();
        } catch (e) {
            console.error('Error showing modal:', e);
            // Fallback to browser confirm
            const result = confirm(message);
            if (callback && typeof callback === 'function') {
                callback(result);
            }
        }
    }

    // AJAX Search with debounce
    function performSearch(searchTerm) {
        loadProducts(currentCategoryId, 1, searchTerm);
                    
                    // Show/hide clear button
                    if (searchTerm && searchTerm.length > 0) {
                        $('#clear-search-btn').show();
                    } else {
                        $('#clear-search-btn').hide();
                    }
    }

    // Search input with debounce (300ms delay)
    $('#pos-search-input').on('input', function() {
        const searchTerm = $(this).val().trim();
        
        // Clear previous timeout
        clearTimeout(searchTimeout);
        
        // Set new timeout
        searchTimeout = setTimeout(function() {
            performSearch(searchTerm);
        }, 300);
    });

    // Clear search
    $('#clear-search-btn').on('click', function() {
        $('#pos-search-input').val('');
        $('#clear-search-btn').hide();
        // Reload products without search
        loadProducts(currentCategoryId, 1, '');
    });

    // Show clear button if there's a search term on page load
    if ($('#pos-search-input').val()) {
        $('#clear-search-btn').show();
    }

    let cartDiscount = {type: 'fixed', value: 0};
    let selectedCustomer = null;
    
    // Update cart data when cart changes
    function updateCartData(cart, discount) {
        currentCartData = cart || {};
        currentCartDiscountData = discount || {type: 'fixed', value: 0};
    }
    
    // Calculate cart totals (client-side)
    function calculateCartTotals(cart, discount) {
        let subtotal = 0;
        let tax = 0;
        let total = 0;
        let discountAmount = 0;
        
        // Calculate item subtotals
        Object.keys(cart).forEach(productId => {
            const item = cart[productId];
            const itemSubtotal = (item.unit_price * item.quantity) - (item.discount || 0);
            const itemTax = itemSubtotal * ((item.tax_rate || 0) / 100);
            subtotal += itemSubtotal;
            tax += itemTax;
        });
        
        // Apply cart discount
        if (discount && discount.value > 0) {
            if (discount.type === 'percentage') {
                discountAmount = subtotal * (discount.value / 100);
            } else {
                discountAmount = discount.value;
            }
        }
        
        total = subtotal - discountAmount + tax;
        
        return {
            subtotal: subtotal,
            tax: tax,
            discount: discountAmount,
            total: total
        };
    }
    
    function updateCartUI(cart, totals, cartCount) {
        // Ensure cart is an object
        if (!cart || typeof cart !== 'object') {
            cart = {};
        }
        
        // Ensure totals is an object
        if (!totals || typeof totals === 'number') {
            totals = {
                subtotal: typeof totals === 'number' ? totals : 0, 
                tax: 0, 
                total: typeof totals === 'number' ? totals : 0, 
                discount: 0
            };
        }
        
        // Ensure cartCount is a number
        if (typeof cartCount !== 'number') {
            cartCount = Object.keys(cart).length || 0;
        }
        
        // Update global cart data for payment modal (if function exists)
        if (typeof updateCartData === 'function') {
            updateCartData(cart, cartDiscount);
        }
        
        if (Object.keys(cart).length === 0) {
            $('#cart-items').html('<p class="text-center text-muted"><?php echo e(trans('messages.cart_is_empty')); ?></p>');
            $('#create-invoice-btn, #save-draft-btn, #clear-cart-btn, #print-ticket-btn, #cart-discount-btn').prop('disabled', true);
            <?php if($posSettings['enable_payment'] ?? false): ?>
            $('#process-payment-btn').prop('disabled', true);
            <?php endif; ?>
            // Hide discount display when cart is empty
            $('#cart-discount-display').parent().hide();
        } else {
            const cartItemsHtml = Object.keys(cart).map(productId => {
                const item = cart[productId];
                const displayName = (item.name_ar && '<?php echo e(app()->getLocale()); ?>' === 'ar') ? item.name_ar : item.name;
                const itemDiscount = item.discount || 0;
                const itemSubtotal = (item.unit_price * item.quantity) - itemDiscount;
                return `
                    <div class="card mb-2 cart-item" data-product-id="${productId}">
                        <div class="card-body p-2">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h6 class="mb-0">${displayName}</h6>
                                <button class="btn btn-sm btn-danger remove-from-cart-btn" data-product-id="${productId}" title="<?php echo e(trans('messages.remove')); ?>">
                                    <i class="bi bi-x"></i>
                                </button>
                            </div>
                            <div class="input-group input-group-sm mb-2">
                                <span class="input-group-text"><?php echo e(trans('messages.quantity')); ?></span>
                                <input type="number" class="form-control cart-quantity" 
                                       data-product-id="${productId}"
                                       value="${item.quantity}" min="1">
                            </div>
                            <div class="input-group input-group-sm mb-2">
                                <span class="input-group-text"><?php echo e(trans('messages.price')); ?></span>
                                <input type="number" class="form-control cart-price" 
                                       data-product-id="${productId}"
                                       value="${parseFloat(item.unit_price).toFixed(2)}" min="0" step="0.01">
                                <button class="btn btn-sm btn-outline-secondary edit-price-btn" data-product-id="${productId}" title="<?php echo e(trans('messages.edit_price')); ?>">
                                    <i class="bi bi-pencil"></i>
                                </button>
                            </div>
                            ${itemDiscount > 0 ? `<div class="mb-2"><small class="text-success"><i class="bi bi-tag"></i> <?php echo e(trans('messages.discount')); ?>: ${parseFloat(itemDiscount).toFixed(2)} <?php echo e(currency_symbol()); ?></small></div>` : ''}
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <small class="text-muted">${parseFloat(item.unit_price).toFixed(2)} <?php echo e(currency_symbol()); ?> x ${item.quantity}</small>
                                <strong class="cart-item-total">${parseFloat(itemSubtotal).toFixed(2)} <?php echo e(currency_symbol()); ?></strong>
                            </div>
                            <div class="d-flex gap-1">
                                <button class="btn btn-sm btn-outline-warning flex-fill item-discount-btn" data-product-id="${productId}" title="<?php echo e(trans('messages.apply_discount')); ?>">
                                    <i class="bi bi-percent"></i> <?php echo e(trans('messages.discount')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                `;
            }).join('');
            $('#cart-items').html(cartItemsHtml);
            $('#create-invoice-btn, #save-draft-btn, #clear-cart-btn, #print-ticket-btn, #cart-discount-btn').prop('disabled', false);
            <?php if($posSettings['enable_payment'] ?? false): ?>
            $('#process-payment-btn').prop('disabled', false);
            <?php endif; ?>
        }
        
        $('#cart-count').text(cartCount);
        $('#cart-subtotal').text(parseFloat(totals.subtotal || 0).toFixed(2) + ' <?php echo e(currency_symbol()); ?>');
        $('#cart-tax').text(parseFloat(totals.tax || 0).toFixed(2) + ' <?php echo e(currency_symbol()); ?>');
        $('#cart-total').text(parseFloat(totals.total || 0).toFixed(2) + ' <?php echo e(currency_symbol()); ?>');
        
        if (totals.discount > 0) {
            $('#cart-discount-display').text('-' + parseFloat(totals.discount).toFixed(2) + ' <?php echo e(currency_symbol()); ?>').parent().show();
        } else {
            $('#cart-discount-display').parent().hide();
        }
        $('#create-invoice-btn').prop('disabled', cartCount === 0);
        <?php if($posSettings['enable_payment'] ?? false): ?>
        $('#process-payment-btn').prop('disabled', cartCount === 0);
        <?php endif; ?>
        
        // Show/hide print ticket and clear cart buttons
        if (cartCount > 0) {
            $('#print-ticket-btn').removeClass('d-none disabled');
            $('#clear-cart-btn').removeClass('d-none');
        } else {
            $('#print-ticket-btn').addClass('d-none disabled');
            $('#clear-cart-btn').addClass('d-none');
        }
        
        // Update print ticket link
        updatePrintTicketLink();
    }

    // Add to cart
    $(document).on('click', '.add-to-cart-btn:not(.disabled)', function() {
        if ($(this).prop('disabled')) {
            return false;
        }
        const productId = $(this).data('product-id');
        const quantity = $(this).closest('.product-card').find('.product-quantity').val();

        $.ajax({
            url: '<?php echo e(route('pos.cart.add')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                product_id: productId,
                quantity: quantity
            },
            success: function(response) {
                if (response && response.success) {
                    showToast(response.message || '<?php echo e(trans('messages.product_added_to_cart')); ?>', 'success');
                    const totals = {
                        subtotal: response.cart_subtotal || response.cart_total || 0,
                        tax: response.cart_tax || 0,
                        total: response.cart_total || 0,
                        discount: response.cart_discount || 0
                    };
                    const cart = response.cart || {};
                    const cartCount = response.cart_count || Object.keys(cart).length || 0;
                    updateCartUI(cart, totals, cartCount);
                } else {
                    showToast(response?.message || '<?php echo e(trans('messages.error')); ?>', 'danger');
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error')); ?>';
                showToast(message, 'danger');
            }
        });
    });

    // Update cart quantity
    $(document).on('change', '.cart-quantity', function() {
        const productId = $(this).data('product-id');
        const quantity = $(this).val();

        $.ajax({
            url: '<?php echo e(route('pos.cart.update')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                product_id: productId,
                quantity: quantity
            },
            success: function(response) {
                if (response.success) {
                    const totals = {
                        subtotal: response.cart_subtotal || response.cart_total,
                        tax: response.cart_tax || 0,
                        total: response.cart_total,
                        discount: response.cart_discount || 0
                    };
                    updateCartUI(response.cart, totals, response.cart_count);
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error')); ?>';
                showToast(message, 'danger');
            }
        });
    });

    // Remove from cart
    $(document).on('click', '.remove-from-cart-btn', function() {
        const productId = $(this).data('product-id');
        const btn = $(this);
        
        showConfirm('<?php echo e(trans('messages.confirm_delete_item')); ?>', function(confirmed) {
            if (!confirmed) {
                return;
            }
            
            $.ajax({
                url: '<?php echo e(route('pos.cart.remove')); ?>',
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    product_id: productId
                },
                success: function(response) {
                    if (response.success) {
                        showToast(response.message, 'success');
                        const totals = {
                            subtotal: response.cart_subtotal || response.cart_total || 0,
                            tax: response.cart_tax || 0,
                            total: response.cart_total || 0,
                            discount: response.cart_discount || 0
                        };
                        updateCartUI(response.cart || {}, totals, response.cart_count || 0);
                    }
                },
                error: function(xhr) {
                    const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error')); ?>';
                    showToast(message, 'danger');
                }
            });
        });
        
        return false;
    });

    // Clear cart
    $('#clear-cart-btn').on('click', function() {
        showConfirm('<?php echo e(trans('messages.confirm_clear_cart')); ?>', function(confirmed) {
            if (!confirmed) {
                return;
            }
            
            $.ajax({
                url: '<?php echo e(route('pos.cart.clear')); ?>',
                method: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    if (response.success) {
                        // Reset cart discount
                        cartDiscount = response.cart_discount || {type: 'fixed', value: 0};
                        // Update cart data
                        if (typeof updateCartData === 'function') {
                            updateCartData(response.cart || {}, cartDiscount);
                        }
                        const totals = {
                            subtotal: response.totals?.subtotal || 0,
                            tax: response.totals?.tax || 0,
                            total: response.totals?.total || 0,
                            discount: response.totals?.discount || 0
                        };
                        updateCartUI(response.cart || {}, totals, response.cart_count || 0);
                        showToast(response.message, 'success');
                    }
                },
                error: function(xhr) {
                    const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error')); ?>';
                    showToast(message, 'danger');
                }
            });
        });
    });

    // Customer selection is handled via search, update print link when customer changes
    // This is handled in customer search handlers below
    
    // Function to update print ticket link
    function updatePrintTicketLink() {
        const customerId = $('#selected-customer-id').val() || '';
        const customerName = $('#selected-customer-name').text().trim() || '<?php echo e(trans('messages.walk_in_customer')); ?>';
        
        const printBtn = $('#print-ticket-btn');
        if (printBtn.length) {
            const baseUrl = '<?php echo e(route('pos.print-ticket')); ?>';
            const params = new URLSearchParams();
            if (customerId) {
                params.append('customer_id', customerId);
            }
            params.append('customer_name', customerName);
            const newHref = baseUrl + '?' + params.toString();
            printBtn.attr('href', newHref);
            // Remove disabled class if cart has items
            const cartCount = Object.keys(currentCartData || {}).length;
            if (cartCount > 0) {
                printBtn.removeClass('disabled');
            } else {
                printBtn.addClass('disabled');
            }
        }
    }
    
    // Initialize print ticket link
    updatePrintTicketLink();
    
    // Show/hide buttons based on initial cart state
    const initialCartCount = <?php echo e(count($cart)); ?>;
    if (initialCartCount > 0) {
        $('#print-ticket-btn').removeClass('d-none');
        $('#clear-cart-btn').removeClass('d-none');
    } else {
        $('#print-ticket-btn').addClass('d-none');
        $('#clear-cart-btn').addClass('d-none');
    }

    // ========== BARCODE SCANNER SUPPORT ==========
    let barcodeInput = '';
    let barcodeTimeout;
    const BARCODE_DELAY = 100; // Time to wait for next character (barcode scanners are fast)

    $('#barcode-input').on('input', function() {
        const value = $(this).val();
        barcodeInput = value;
        
        clearTimeout(barcodeTimeout);
        barcodeTimeout = setTimeout(function() {
            if (barcodeInput.length >= 3) { // Minimum barcode length
                searchByBarcode(barcodeInput);
            }
            barcodeInput = '';
            $('#barcode-input').val('');
        }, BARCODE_DELAY);
    });

    function searchByBarcode(barcode) {
        $.ajax({
            url: '<?php echo e(route('pos.barcode')); ?>',
            method: 'GET',
            data: { barcode: barcode },
            success: function(response) {
                if (response.success && response.product) {
                    const product = response.product;
                    if (product.can_add) {
                        // Add product to cart automatically
                        addProductToCart(product.id, 1);
                        showToast('<?php echo e(trans('messages.product_added_to_cart')); ?>', 'success');
                        // Play success sound
                        playBeepSound('success');
                    } else {
                        showToast('<?php echo e(trans('messages.out_of_stock')); ?>', 'danger');
                        playBeepSound('error');
                    }
                } else {
                    showToast(response.message || '<?php echo e(trans('messages.product_not_found')); ?>', 'danger');
                    playBeepSound('error');
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.product_not_found')); ?>';
                showToast(message, 'danger');
                playBeepSound('error');
            }
        });
    }

    function addProductToCart(productId, quantity) {
        $.ajax({
            url: '<?php echo e(route('pos.cart.add')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                product_id: productId,
                quantity: quantity
            },
            success: function(response) {
                if (response.success) {
                    showToast(response.message || '<?php echo e(trans('messages.product_added_to_cart')); ?>', 'success');
                    const totals = {
                        subtotal: response.cart_subtotal || response.cart_total || 0,
                        tax: response.cart_tax || 0,
                        total: response.cart_total || 0,
                        discount: response.cart_discount || 0
                    };
                    updateCartUI(response.cart || {}, totals, response.cart_count || 0);
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error')); ?>';
                showToast(message, 'danger');
            }
        });
    }

    // ========== KEYBOARD SHORTCUTS ==========
    $(document).on('keydown', function(e) {
        // Don't trigger shortcuts when typing in inputs
        if ($(e.target).is('input, textarea, select')) {
            // Allow some shortcuts even in inputs
            if (e.key === '/' && $(e.target).attr('id') !== 'pos-search-input') {
                e.preventDefault();
                $('#pos-search-input').focus();
                return;
            }
            if (e.ctrlKey && e.key === 'b') {
                e.preventDefault();
                $('#barcode-input').focus();
                return;
            }
            if (e.key === 'Enter' && $(e.target).hasClass('product-quantity')) {
                e.preventDefault();
                $(e.target).closest('.product-card').find('.add-to-cart-btn').click();
                return;
            }
            return;
        }

        // Focus search on /
        if (e.key === '/') {
            e.preventDefault();
            $('#pos-search-input').focus();
        }
        
        // Focus barcode on Ctrl+B
        if (e.ctrlKey && e.key === 'b') {
            e.preventDefault();
            $('#barcode-input').focus();
        }
        
        // Create invoice on Ctrl+Enter
        if (e.ctrlKey && e.key === 'Enter') {
            e.preventDefault();
            <?php if($posSettings['enable_payment'] ?? false): ?>
            if (!$('#process-payment-btn').prop('disabled')) {
                $('#process-payment-btn').click();
            } else if (!$('#create-invoice-btn').prop('disabled')) {
                $('#create-invoice-btn').click();
            }
            <?php else: ?>
            if (!$('#create-invoice-btn').prop('disabled')) {
                $('#create-invoice-btn').click();
            }
            <?php endif; ?>
        }
        
        // Print receipt on Ctrl+P
        if (e.ctrlKey && e.key === 'p') {
            e.preventDefault();
            const printBtn = $('#print-ticket-btn');
            if (printBtn.length && printBtn.is(':visible') && !printBtn.hasClass('disabled')) {
                const href = printBtn.attr('href');
                if (href) {
                    window.open(href, '_blank');
                }
            }
        }
        
        // Clear cart on Delete
        if (e.key === 'Delete' && !$(e.target).is('input, textarea')) {
            if ($('#clear-cart-btn').is(':visible')) {
                $('#clear-cart-btn').click();
            }
        }
    });

    // Shortcut help modal
    $('#shortcut-help-btn').on('click', function() {
        const modal = new bootstrap.Modal(document.getElementById('shortcut-help-modal'));
        modal.show();
    });

    // ========== OFFLINE MODE ==========
    let isOffline = false;
    let offlineData = JSON.parse(localStorage.getItem('pos_offline_data') || '[]');

    function checkOnlineStatus() {
        if (navigator.onLine) {
            if (isOffline) {
                // Coming back online
                syncOfflineData();
            }
            isOffline = false;
            $('#offline-toggle-btn').removeClass('btn-warning').addClass('btn-outline-light');
            $('#connection-status').text('<?php echo e(trans('messages.online_mode')); ?>');
            $('#offline-toggle-btn i').removeClass('bi-wifi-off').addClass('bi-wifi');
        } else {
            isOffline = true;
            $('#offline-toggle-btn').removeClass('btn-outline-light').addClass('btn-warning');
            $('#connection-status').text('<?php echo e(trans('messages.offline_mode')); ?>');
            $('#offline-toggle-btn i').removeClass('bi-wifi').addClass('bi-wifi-off');
        }
    }

    // Check on page load
    checkOnlineStatus();

    // Listen for online/offline events
    window.addEventListener('online', checkOnlineStatus);
    window.addEventListener('offline', checkOnlineStatus);

    // Manual offline toggle
    $('#offline-toggle-btn').on('click', function() {
        if (isOffline) {
            syncOfflineData();
        } else {
            isOffline = true;
            $('#offline-toggle-btn').removeClass('btn-outline-light').addClass('btn-warning');
            $('#connection-status').text('<?php echo e(trans('messages.offline_mode')); ?>');
            $('#offline-toggle-btn i').removeClass('bi-wifi').addClass('bi-wifi-off');
            showToast('<?php echo e(trans('messages.offline_mode')); ?>', 'warning');
        }
    });

    function syncOfflineData() {
        if (offlineData.length === 0) {
            isOffline = false;
            checkOnlineStatus();
            return;
        }

        showToast('<?php echo e(trans('messages.sync_pending_data')); ?>...', 'info');
        
        // Sync each offline action
        offlineData.forEach(function(action, index) {
            $.ajax({
                url: action.url,
                method: action.method,
                data: action.data,
                success: function() {
                    offlineData.splice(index, 1);
                    localStorage.setItem('pos_offline_data', JSON.stringify(offlineData));
                    
                    if (offlineData.length === 0) {
                        isOffline = false;
                        checkOnlineStatus();
                        showToast('<?php echo e(trans('messages.offline_data_saved')); ?>', 'success');
                    }
                },
                error: function() {
                    // Keep in offline data for next sync
                }
            });
        });
    }

    // Save to offline storage when offline
    function saveOfflineAction(url, method, data) {
        if (isOffline) {
            offlineData.push({ url, method, data, timestamp: new Date().toISOString() });
            localStorage.setItem('pos_offline_data', JSON.stringify(offlineData));
            showToast('<?php echo e(trans('messages.offline_data_saved')); ?>', 'info');
        }
    }

    // Auto print is now controlled by settings (pos_auto_print)

    // ========== PRINTER SELECTION ==========
    function loadPrinters() {
        if (navigator.serial) {
            // Web Serial API available
            navigator.serial.getPorts().then(ports => {
                ports.forEach(port => {
                    $('#printer-select').append(`<option value="${port}">${port.getInfo().usbVendorId}</option>`);
                });
            });
        } else {
            // Fallback: Use browser print dialog
            $('#printer-select').html('<option value="default"><?php echo e(trans('messages.default_printer')); ?></option>');
        }
    }

    loadPrinters();

    // Save printer preference
    const savedPrinter = localStorage.getItem('pos_printer') || 'default';
    $('#printer-select').val(savedPrinter);

    $('#printer-select').on('change', function() {
        localStorage.setItem('pos_printer', $(this).val());
    });
    
    // ========== DISCOUNT FEATURES ==========
    // Cart discount
    $('#cart-discount-btn').on('click', function() {
        const modal = new bootstrap.Modal(document.getElementById('cart-discount-modal'));
        $('#discount-type').val(cartDiscount.type);
        $('#discount-value').val(cartDiscount.value);
        updateDiscountHint();
        modal.show();
    });
    
    $('#discount-type').on('change', updateDiscountHint);
    
    function updateDiscountHint() {
        const type = $('#discount-type').val();
        const total = parseFloat($('#cart-total').text().replace(/[^\d.]/g, '')) || 0;
        if (type === 'percentage') {
            $('#discount-hint').text('<?php echo e(trans('messages.maximum')); ?>: 100%');
        } else {
            $('#discount-hint').text('<?php echo e(trans('messages.maximum')); ?>: ' + total.toFixed(2) + ' <?php echo e(currency_symbol()); ?>');
        }
    }
    
    $('#apply-cart-discount-btn').on('click', function() {
        const type = $('#discount-type').val();
        const value = parseFloat($('#discount-value').val()) || 0;
        
        if (value <= 0) {
            showToast('<?php echo e(trans('messages.discount_value')); ?> <?php echo e(trans('messages.required')); ?>', 'danger');
            return;
        }
        
        $.ajax({
            url: '<?php echo e(route('pos.cart.discount')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                discount_type: type,
                discount_value: value
            },
            success: function(response) {
                if (response.success) {
                    cartDiscount = response.cart_discount || {type: 'fixed', value: 0};
                    // Update cart data
                    if (typeof updateCartData === 'function') {
                        updateCartData(response.cart || {}, cartDiscount);
                    }
                    // Ensure we have a valid cart object
                    const cart = response.cart || {};
                    const cartCount = response.cart_count || Object.keys(cart).length;
                    updateCartUI(cart, response.totals, cartCount);
                    bootstrap.Modal.getInstance(document.getElementById('cart-discount-modal')).hide();
                    showToast('<?php echo e(trans('messages.discount_applied')); ?>', 'success');
                } else {
                    showToast(response.message || '<?php echo e(trans('messages.error')); ?>', 'danger');
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error')); ?>';
                showToast(message, 'danger');
            }
        });
    });
    
    // Item discount
    $(document).on('click', '.item-discount-btn', function() {
        const productId = $(this).data('product-id');
        const cartItem = $(this).closest('.cart-item');
        
        // Get item data from the cart item element
        const itemName = cartItem.find('h6').text().trim();
        const itemPrice = parseFloat(cartItem.find('.cart-price').val()) || 0;
        const itemQuantity = parseInt(cartItem.find('.cart-quantity').val()) || 1;
        const currentDiscount = parseFloat(cartItem.find('.text-success').text().replace(/[^\d.]/g, '')) || 0;
        
        $('#item-discount-product-id').val(productId);
        $('#item-discount-product-name').val(itemName);
        $('#item-discount-type').val('fixed');
        $('#item-discount-value').val(currentDiscount);
        
        const modal = new bootstrap.Modal(document.getElementById('item-discount-modal'));
        modal.show();
    });
    
    $('#apply-item-discount-btn').on('click', function() {
        const productId = $('#item-discount-product-id').val();
        const type = $('#item-discount-type').val();
        const value = parseFloat($('#item-discount-value').val()) || 0;
        
        $.ajax({
            url: '<?php echo e(route('pos.cart.item.discount')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                product_id: productId,
                discount_type: type,
                discount_value: value
            },
            success: function(response) {
                if (response.success) {
                    const totals = {
                        subtotal: response.totals?.subtotal || 0,
                        tax: response.totals?.tax || 0,
                        total: response.totals?.total || 0,
                        discount: response.totals?.discount || 0
                    };
                    updateCartUI(response.cart || {}, totals, response.cart_count || Object.keys(response.cart || {}).length);
                    bootstrap.Modal.getInstance(document.getElementById('item-discount-modal')).hide();
                    showToast('<?php echo e(trans('messages.discount_applied')); ?>', 'success');
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error')); ?>';
                showToast(message, 'danger');
            }
        });
    });
    
    // Edit price
    $(document).on('click', '.edit-price-btn', function() {
        const productId = $(this).data('product-id');
        const priceInput = $(this).closest('.input-group').find('.cart-price');
        const newPrice = parseFloat(priceInput.val()) || 0;
        
        if (newPrice <= 0) {
            showToast('<?php echo e(trans('messages.invalid_price')); ?>', 'danger');
            return;
        }
        
        $.ajax({
            url: '<?php echo e(route('pos.cart.item.price')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                product_id: productId,
                price: newPrice
            },
            success: function(response) {
                if (response.success) {
                    updateCartUI(response.cart || {}, response.totals, Object.keys(response.cart || {}).length);
                    showToast('<?php echo e(trans('messages.price_updated')); ?>', 'success');
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error')); ?>';
                showToast(message, 'danger');
            }
        });
    });
    
    // ========== CUSTOMER FEATURES ==========
    let customerSearchTimeout;
    $('#customer-search-input').on('input', function() {
        const search = $(this).val().trim();
        clearTimeout(customerSearchTimeout);
        
        if (search.length < 2) {
            $('#customer-search-results').hide();
            return;
        }
        
        customerSearchTimeout = setTimeout(function() {
            $.ajax({
                url: '<?php echo e(route('pos.customers.search')); ?>',
                method: 'GET',
                data: { search: search },
                success: function(response) {
                    if (response.success) {
                        const resultsHtml = response.customers.map(customer => `
                            <div class="p-2 border-bottom customer-result-item" style="cursor: pointer;" 
                                 data-customer-id="${customer.id}" 
                                 data-customer-name="${customer.name}"
                                 data-customer-balance="${customer.balance}">
                                <strong>${customer.name}</strong>
                                ${customer.phone ? '<br><small>' + customer.phone + '</small>' : ''}
                                <br><small class="text-muted">Balance: ${parseFloat(customer.balance).toFixed(2)} <?php echo e(currency_symbol()); ?></small>
                            </div>
                        `).join('');
                        $('#customer-search-results').html(resultsHtml || '<div class="p-2 text-muted"><?php echo e(trans('messages.no_results')); ?></div>').show();
                    }
                }
            });
        }, 300);
    });
    
    $(document).on('click', '.customer-result-item', function() {
        const customerId = $(this).data('customer-id');
        const customerName = $(this).data('customer-name');
        const customerBalance = $(this).data('customer-balance');
        
        selectedCustomer = {id: customerId, name: customerName, balance: customerBalance};
        $('#selected-customer-id').val(customerId);
        $('#selected-customer-name').text(customerName);
        $('#selected-customer-balance').text(parseFloat(customerBalance).toFixed(2) + ' <?php echo e(currency_symbol()); ?>');
        $('#selected-customer-info').show();
        $('#clear-customer-btn').show();
        $('#customer-search-input').val('');
        $('#customer-search-results').hide();
        updatePrintTicketLink();
    });
    
    $('#clear-customer-btn').on('click', function() {
        selectedCustomer = null;
        $('#selected-customer-id').val('');
        $('#selected-customer-name').text('<?php echo e(trans('messages.walk_in_customer')); ?>');
        $('#selected-customer-balance').text('0.00 <?php echo e(currency_symbol()); ?>');
        $('#selected-customer-info').show();
        $('#clear-customer-btn').hide();
        updatePrintTicketLink();
    });
    
    $('#quick-add-customer-btn').on('click', function() {
        const modal = new bootstrap.Modal(document.getElementById('quick-add-customer-modal'));
        $('#quick-add-customer-form')[0].reset();
        modal.show();
    });
    
    $('#save-quick-customer-btn').on('click', function() {
        const form = $('#quick-add-customer-form');
        if (!form[0].checkValidity()) {
            form[0].reportValidity();
            return;
        }
        
        $.ajax({
            url: '<?php echo e(route('pos.customers.quick-add')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                name: form.find('[name="name"]').val(),
                phone: form.find('[name="phone"]').val(),
                email: form.find('[name="email"]').val()
            },
            success: function(response) {
                if (response.success) {
                    selectedCustomer = response.customer;
                    $('#selected-customer-id').val(response.customer.id);
                    $('#selected-customer-name').text(response.customer.name);
                    $('#selected-customer-balance').text('0.00 <?php echo e(currency_symbol()); ?>');
                    $('#selected-customer-info').show();
                    $('#clear-customer-btn').show();
                    bootstrap.Modal.getInstance(document.getElementById('quick-add-customer-modal')).hide();
                    showToast('<?php echo e(trans('messages.customer_created')); ?>', 'success');
                    updatePrintTicketLink();
                }
            },
            error: function(xhr) {
                const message = xhr.responseJSON?.message || '<?php echo e(trans('messages.error')); ?>';
                showToast(message, 'danger');
            }
        });
    });
    
    // ========== STATS ==========
    function loadTodayStats() {
        $.ajax({
            url: '<?php echo e(route('pos.stats.today')); ?>',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    $('#today-total-sales').text(parseFloat(response.stats.total_sales).toFixed(2) + ' <?php echo e(currency_symbol()); ?>');
                    $('#today-invoice-count').text(response.stats.invoice_count);
                }
            }
        });
    }
    
    loadTodayStats();
    setInterval(loadTodayStats, 60000); // Update every minute
    
    // ========== DRAFT FEATURES ==========
    $('#save-draft-btn').on('click', function() {
        $.ajax({
            url: '<?php echo e(route('pos.draft.save')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                customer_id: selectedCustomer ? selectedCustomer.id : ''
            },
            success: function(response) {
                if (response.success) {
                    showToast(response.message, 'success');
                }
            }
        });
    });
    
    // ========== KEYBOARD SHORTCUTS ==========
    $(document).on('keydown', function(e) {
        if ($(e.target).is('input, textarea, select')) return;
        
        // Ctrl+D: Discount
        if (e.ctrlKey && e.key === 'd') {
            e.preventDefault();
            $('#cart-discount-btn').click();
        }
        
        // F11: Fullscreen
        if (e.key === 'F11') {
            e.preventDefault();
            toggleFullscreen();
        }
    });
    
    // Fullscreen toggle function
    function toggleFullscreen() {
        if (!document.fullscreenElement && !document.webkitFullscreenElement && !document.mozFullScreenElement && !document.msFullscreenElement) {
            // Enter fullscreen
            if (document.documentElement.requestFullscreen) {
                document.documentElement.requestFullscreen();
            } else if (document.documentElement.webkitRequestFullscreen) {
                document.documentElement.webkitRequestFullscreen();
            } else if (document.documentElement.mozRequestFullScreen) {
                document.documentElement.mozRequestFullScreen();
            } else if (document.documentElement.msRequestFullscreen) {
                document.documentElement.msRequestFullscreen();
            }
        } else {
            // Exit fullscreen
            if (document.exitFullscreen) {
                document.exitFullscreen();
            } else if (document.webkitExitFullscreen) {
                document.webkitExitFullscreen();
            } else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            }
        }
    }
    
    // Add fullscreen button
    <?php if($posSettings['enable_fullscreen'] ?? true): ?>
    const fullscreenBtn = $('<button>').attr({
        type: 'button',
        class: 'btn btn-sm btn-outline-light',
        id: 'fullscreen-toggle-btn',
        title: '<?php echo e(trans('messages.fullscreen')); ?>'
    }).html('<i class="bi bi-fullscreen"></i>');
    
    $('#shortcut-help-btn').after(fullscreenBtn);
    
    $('#fullscreen-toggle-btn').on('click', function() {
        toggleFullscreen();
    });
    
    // Update icon on fullscreen change
    function updateFullscreenIcon() {
        const isFullscreen = !!(document.fullscreenElement || document.webkitFullscreenElement || document.mozFullScreenElement || document.msFullscreenElement);
        const icon = $('#fullscreen-toggle-btn i');
        if (isFullscreen) {
            icon.removeClass('bi-fullscreen').addClass('bi-fullscreen-exit');
        } else {
            icon.removeClass('bi-fullscreen-exit').addClass('bi-fullscreen');
        }
    }
    
    document.addEventListener('fullscreenchange', updateFullscreenIcon);
    document.addEventListener('webkitfullscreenchange', updateFullscreenIcon);
    document.addEventListener('mozfullscreenchange', updateFullscreenIcon);
    document.addEventListener('MSFullscreenChange', updateFullscreenIcon);
    <?php endif; ?>
    
    // ========== SOUND EFFECTS ==========
    function playBeepSound(type) {
        <?php if($posSettings['enable_sound'] ?? true): ?>
        try {
            const audioContext = new (window.AudioContext || window.webkitAudioContext)();
            const oscillator = audioContext.createOscillator();
            const gainNode = audioContext.createGain();
            
            oscillator.connect(gainNode);
            gainNode.connect(audioContext.destination);
            
            if (type === 'success') {
                // Success beep: ascending three-tone melody (pleasant)
                const now = audioContext.currentTime;
                oscillator.type = 'sine';
                
                // First beep
                oscillator.frequency.setValueAtTime(523.25, now); // C5
                gainNode.gain.setValueAtTime(0, now);
                gainNode.gain.linearRampToValueAtTime(0.25, now + 0.02);
                gainNode.gain.linearRampToValueAtTime(0, now + 0.08);
                
                // Second beep
                oscillator.frequency.setValueAtTime(659.25, now + 0.1); // E5
                gainNode.gain.linearRampToValueAtTime(0.25, now + 0.1);
                gainNode.gain.linearRampToValueAtTime(0, now + 0.18);
                
                // Third beep
                oscillator.frequency.setValueAtTime(783.99, now + 0.2); // G5
                gainNode.gain.linearRampToValueAtTime(0.25, now + 0.2);
                gainNode.gain.linearRampToValueAtTime(0, now + 0.28);
                
                oscillator.start(now);
                oscillator.stop(now + 0.28);
            } else if (type === 'error') {
                // Error beep: descending low-pitched beep (warning sound)
                const now = audioContext.currentTime;
                oscillator.type = 'square'; // Square wave for harsher sound
                
                // Start high, go low
                oscillator.frequency.setValueAtTime(400, now);
                oscillator.frequency.exponentialRampToValueAtTime(200, now + 0.4);
                
                gainNode.gain.setValueAtTime(0, now);
                gainNode.gain.linearRampToValueAtTime(0.4, now + 0.05);
                gainNode.gain.linearRampToValueAtTime(0.2, now + 0.2);
                gainNode.gain.linearRampToValueAtTime(0, now + 0.4);
                
                oscillator.start(now);
                oscillator.stop(now + 0.4);
            } else {
                // Default beep: simple single tone
                const now = audioContext.currentTime;
                oscillator.type = 'sine';
                oscillator.frequency.setValueAtTime(600, now);
                gainNode.gain.setValueAtTime(0, now);
                gainNode.gain.linearRampToValueAtTime(0.2, now + 0.02);
                gainNode.gain.linearRampToValueAtTime(0, now + 0.15);
                oscillator.start(now);
                oscillator.stop(now + 0.15);
            }
        } catch (e) {
            // Fallback: use simple beep if Web Audio API is not available
            console.log('Audio not available:', e);
        }
        <?php endif; ?>
    }
    
    <?php if($posSettings['enable_sound'] ?? false): ?>
    function playSound(type) {
        const audio = new Audio('/sounds/' + type + '.mp3');
        audio.play().catch(() => {}); // Ignore errors
    }
    <?php endif; ?>
    
    // ========== CONFIRM DELETE ==========
    
    // ========== QUICK SALES (FAVORITES & RECENT) ==========
    $('#show-favorites-btn').on('click', function() {
        $.ajax({
            url: '<?php echo e(route('pos.products.favorites')); ?>',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    if (response.products.length === 0) {
                        showToast('<?php echo e(trans('messages.no_favorites')); ?>', 'info');
                        return;
                    }
                    displayQuickProducts(response.products, '<?php echo e(trans('messages.favorites')); ?>');
                }
            }
        });
    });
    
    $('#show-recent-btn').on('click', function() {
        $.ajax({
            url: '<?php echo e(route('pos.products.recent')); ?>',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    if (response.products.length === 0) {
                        showToast('<?php echo e(trans('messages.no_recent_products')); ?>', 'info');
                        return;
                    }
                    displayQuickProducts(response.products, '<?php echo e(trans('messages.recently_sold')); ?>');
                }
            }
        });
    });
    
    function displayQuickProducts(products, title) {
        const productsHtml = products.map(product => {
            const displayName = (product.name_ar && '<?php echo e(app()->getLocale()); ?>' === 'ar') ? product.name_ar : product.name;
            return `
                <div class="col-md-4 col-sm-6">
                    <div class="card h-100 product-card">
                        <div class="card-body">
                            <h6 class="card-title">${displayName}</h6>
                            <p class="card-text mb-2">
                                <strong>${parseFloat(product.selling_price).toFixed(2)} <?php echo e(currency_symbol()); ?></strong>
                            </p>
                            <div class="input-group mb-2">
                                <input type="number" class="form-control product-quantity" 
                                       data-product-id="${product.id}" 
                                       value="1" min="1">
                                <button class="btn btn-primary add-to-cart-btn" 
                                        data-product-id="${product.id}"
                                        data-product-name="${displayName}">
                                    <i class="bi bi-cart-plus"></i> <?php echo e(trans('messages.add_to_cart')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        }).join('');
        
        $('#products-grid').html(productsHtml);
        $('#products-pagination').hide();
        showToast(title, 'info');
    }
    
    // Toggle favorite on product card
    $(document).on('click', '.toggle-favorite-btn', function(e) {
        e.stopPropagation();
        const productId = $(this).data('product-id');
        const btn = $(this);
        
        $.ajax({
            url: '<?php echo e(route('pos.products.toggle-favorite')); ?>',
            method: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                product_id: productId
            },
            success: function(response) {
                if (response.success) {
                    if (response.is_favorite) {
                        btn.removeClass('btn-outline-warning').addClass('btn-warning');
                        showToast('<?php echo e(trans('messages.added_to_favorites')); ?>', 'success');
                    } else {
                        btn.removeClass('btn-warning').addClass('btn-outline-warning');
                        showToast('<?php echo e(trans('messages.removed_from_favorites')); ?>', 'info');
                    }
                }
            }
        });
    });
    
    // Initialize: Set default customer to walk-in
    selectedCustomer = null;
    $('#selected-customer-id').val('');
    $('#selected-customer-name').text('<?php echo e(trans('messages.walk_in_customer')); ?>');
    $('#selected-customer-balance').text('0.00 <?php echo e(currency_symbol()); ?>');
    
    // Load favorites status for products
    function loadFavoritesStatus() {
        $.ajax({
            url: '<?php echo e(route('pos.products.favorites')); ?>',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    const favorites = response.products.map(p => p.id);
                    $('.toggle-favorite-btn').each(function() {
                        const productId = $(this).data('product-id');
                        if (favorites.includes(productId)) {
                            $(this).removeClass('btn-outline-warning').addClass('btn-warning');
                        }
                    });
                }
            }
        });
    }
    
    // Load favorites status after products are loaded
    setTimeout(loadFavoritesStatus, 500);
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/pos/index.blade.php ENDPATH**/ ?>