<?php
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
?>
<!DOCTYPE html>
<html lang="<?php echo e($locale); ?>" dir="<?php echo e($isRTL ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($isRTL ? 'اختبار الفترة التجريبية' : 'Trial Period Test'); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('lib/fonts/google-fonts.css')); ?>">
    <link href="<?php echo e(asset('lib/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('lib/icons/bootstrap-icons/bootstrap-icons.css')); ?>">
    <style>
        <?php
            $fontFamily = $isRTL ? "'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif" : "'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif";
        ?>
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        <?php if($isRTL): ?>
        * {
            font-family: 'Cairo', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        <?php else: ?>
        * {
            font-family: 'Cabin', 'DejaVu Sans', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif !important;
        }
        <?php endif; ?>
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            font-family: <?php echo e($fontFamily); ?>;
            padding: 20px 15px;
        }
        
        .container {
            max-width: 1000px;
            margin: 0 auto;
        }
        
        .card {
            border: none;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            overflow: hidden;
            animation: slideUp 0.5s ease-out;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 18px 30px;
            border: none;
        }
        
        .card-header h4 {
            font-weight: 700;
            font-size: 1.25rem;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .card-header i {
            font-size: 1.4rem;
        }
        
        .card-body {
            padding: 22px 30px;
            background: white;
        }
        
        .alert {
            border-radius: 12px;
            border: none;
            padding: 10px 16px;
            margin-bottom: 15px;
            box-shadow: 0 3px 10px rgba(0,0,0,0.08);
        }
        
        .alert-success {
            background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
            color: #155724;
            border-left: 4px solid #28a745;
        }
        
        .alert-info {
            background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%);
            color: #0c5460;
            border-left: 4px solid #17a2b8;
        }
        
        h5 {
            font-weight: 600;
            color: #2c3e50;
            margin-bottom: 12px;
            font-size: 1.1rem;
        }
        
        .table {
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 3px 10px rgba(0,0,0,0.05);
        }
        
        .table th {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            color: #2c3e50;
            font-weight: 600;
            padding: 10px;
            border: none;
            font-size: 0.9rem;
        }
        
        .table td {
            padding: 10px;
            border: none;
            color: #495057;
            vertical-align: middle;
            font-size: 0.85rem;
        }
        
        .table tbody tr {
            border-bottom: 1px solid #e9ecef;
            transition: background-color 0.2s;
        }
        
        .table tbody tr:hover {
            background-color: #f8f9fa;
        }
        
        .table tbody tr:last-child {
            border-bottom: none;
        }
        
        .badge {
            padding: 8px 15px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.9rem;
        }
        
        hr {
            margin: 15px 0;
            border: none;
            border-top: 2px solid #e9ecef;
        }
        
        .btn-group {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
            margin-bottom: 12px;
        }
        
        .btn {
            font-weight: 600;
            padding: 10px 20px;
            border-radius: 10px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            border: none;
            display: inline-flex;
            align-items: center;
            gap: 6px;
            font-size: 0.9rem;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(0,0,0,0.15);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
            color: white;
        }
        
        .btn-warning {
            background: linear-gradient(135deg, #ffc107 0%, #e0a800 100%);
            color: #212529;
        }
        
        .btn-info {
            background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
            color: white;
        }
        
        .btn-success {
            background: linear-gradient(135deg, #28a745 0%, #218838 100%);
            color: white;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        
        .btn i {
            font-size: 1.1rem;
        }
        
        .action-buttons {
            display: flex;
            flex-wrap: wrap;
            gap: 6px;
            margin-top: 12px;
        }
        
        @media (max-width: 768px) {
            body {
                padding: 15px 10px;
            }
            
            .card-body {
                padding: 20px;
            }
            
            .card-header h4 {
                font-size: 1.2rem;
            }
            
            .table {
                font-size: 0.9rem;
            }
            
            .table th,
            .table td {
                padding: 10px;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
            
            .btn-group {
                flex-direction: column;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header">
                <h4>
                    <i class="bi bi-gear"></i> 
                    <?php echo e($isRTL ? 'اختبار الفترة التجريبية' : 'Trial Period Test'); ?>

                </h4>
            </div>
            <div class="card-body">
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <div class="alert alert-info">
                    <i class="bi bi-info-circle"></i> 
                    <strong><?php echo e($isRTL ? 'ملاحظة:' : 'Note:'); ?></strong> 
                    <?php echo e($isRTL ? 'هذه الصفحة للاختبار فقط. احذفها في الإنتاج.' : 'This page is for testing only. Delete it in production.'); ?>

                </div>

                <h5><?php echo e($isRTL ? 'معلومات الفترة الحالية:' : 'Current Trial Information:'); ?></h5>
                <table class="table table-bordered">
                    <tr>
                        <th width="200"><?php echo e($isRTL ? 'تاريخ البداية' : 'Start Date'); ?></th>
                        <td><?php echo e($trialInfo['start_date']); ?></td>
                    </tr>
                    <tr>
                        <th><?php echo e($isRTL ? 'تاريخ الانتهاء' : 'End Date'); ?></th>
                        <td><?php echo e($trialInfo['end_date']); ?></td>
                    </tr>
                    <tr>
                        <th><?php echo e($isRTL ? 'الأيام المتبقية' : 'Days Remaining'); ?></th>
                        <td>
                            <span class="badge bg-<?php echo e($trialInfo['days_remaining'] > 0 ? 'success' : 'danger'); ?>">
                                <?php echo e($trialInfo['days_remaining']); ?> <?php echo e($isRTL ? 'يوم' : 'days'); ?>

                            </span>
                        </td>
                    </tr>
                    <tr>
                        <th><?php echo e($isRTL ? 'الحالة' : 'Status'); ?></th>
                        <td>
                            <?php if($trialInfo['is_expired']): ?>
                                <span class="badge bg-danger">
                                    <i class="bi bi-x-circle"></i> <?php echo e($isRTL ? 'منتهية' : 'Expired'); ?>

                                </span>
                            <?php elseif($trialInfo['is_expiring_soon']): ?>
                                <span class="badge bg-warning">
                                    <i class="bi bi-exclamation-triangle"></i> <?php echo e($isRTL ? 'قريبة من الانتهاء' : 'Expiring Soon'); ?>

                                </span>
                            <?php else: ?>
                                <span class="badge bg-success">
                                    <i class="bi bi-check-circle"></i> <?php echo e($isRTL ? 'نشطة' : 'Active'); ?>

                                </span>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>

                <hr>

                <h5><?php echo e($isRTL ? 'اختبار سريع:' : 'Quick Test:'); ?></h5>
                <div class="btn-group" role="group">
                    <a href="<?php echo e(route('trial.test', ['days' => 21])); ?>" class="btn btn-danger">
                        <i class="bi bi-x-circle"></i> 
                        <?php echo e($isRTL ? 'جعلها منتهية (21 يوم)' : 'Make Expired (21 days)'); ?>

                    </a>
                    <a href="<?php echo e(route('trial.test', ['days' => 18])); ?>" class="btn btn-warning">
                        <i class="bi bi-exclamation-triangle"></i> 
                        <?php echo e($isRTL ? 'قبل 3 أيام (18 يوم)' : '3 Days Before (18 days)'); ?>

                    </a>
                    <a href="<?php echo e(route('trial.test', ['days' => 10])); ?>" class="btn btn-info">
                        <i class="bi bi-info-circle"></i> 
                        <?php echo e($isRTL ? '10 أيام متبقية' : '10 Days Remaining'); ?>

                    </a>
                    <a href="<?php echo e(route('trial.reset')); ?>" class="btn btn-success">
                        <i class="bi bi-arrow-clockwise"></i> 
                        <?php echo e($isRTL ? 'إعادة تعيين' : 'Reset'); ?>

                    </a>
                </div>

                <hr>

                <h5><?php echo e($isRTL ? 'رؤية صفحة انتهاء الفترة:' : 'View Expiration Page:'); ?></h5>
                <div class="action-buttons">
                    <a href="<?php echo e(route('trial.expired')); ?>" class="btn btn-primary">
                        <i class="bi bi-eye"></i> 
                        <?php echo e($isRTL ? 'عرض صفحة انتهاء الفترة' : 'View Expiration Page'); ?>

                    </a>
                    <a href="<?php echo e(route('license.activate')); ?>" class="btn btn-secondary">
                        <i class="bi bi-key"></i> 
                        <?php echo e($isRTL ? 'صفحة تفعيل الترخيص' : 'License Activation Page'); ?>

                    </a>
                    <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary">
                        <i class="bi bi-arrow-left"></i> 
                        <?php echo e($isRTL ? 'العودة للوحة التحكم' : 'Back to Dashboard'); ?>

                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/trial/test.blade.php ENDPATH**/ ?>