

<?php $__env->startSection('title', trans('messages.activity_logs')); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2><?php echo e(trans('messages.activity_logs')); ?></h2>
    <?php if(auth()->user()->hasRole('Super Admin')): ?>
    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#clearLogsModal">
        <i class="bi bi-trash"></i> <?php echo e(trans('messages.clear_logs')); ?>

    </button>
    <?php endif; ?>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('activity-logs.index')); ?>">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="user_id" class="form-label"><?php echo e(trans('messages.user')); ?></label>
                    <select name="user_id" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_users')); ?></option>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($user->id); ?>" <?php echo e(request('user_id') == $user->id ? 'selected' : ''); ?>>
                            <?php echo e($user->name); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="action" class="form-label"><?php echo e(trans('messages.action')); ?></label>
                    <select name="action" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_actions')); ?></option>
                        <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($action); ?>" <?php echo e(request('action') == $action ? 'selected' : ''); ?>>
                            <?php echo e(trans('messages.' . $action)); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="model_type" class="form-label"><?php echo e(trans('messages.model_type')); ?></label>
                    <select name="model_type" class="form-select">
                        <option value=""><?php echo e(trans('messages.all_types')); ?></option>
                        <?php $__currentLoopData = $modelTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modelType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($modelType); ?>" <?php echo e(request('model_type') == $modelType ? 'selected' : ''); ?>>
                            <?php echo e(class_basename($modelType)); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="date_from" class="form-label"><?php echo e(trans('messages.from_date')); ?></label>
                    <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="date_to" class="form-label"><?php echo e(trans('messages.to_date')); ?></label>
                    <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                </div>
                <div class="col-md-12">
                    <div class="input-group">
                        <input type="text" name="search" class="form-control" placeholder="<?php echo e(trans('messages.search')); ?>..." value="<?php echo e(request('search')); ?>">
                        <button type="submit" class="btn btn-primary"><?php echo e(trans('messages.filter')); ?></button>
                        <a href="<?php echo e(route('activity-logs.index')); ?>" class="btn btn-secondary"><?php echo e(trans('messages.reset')); ?></a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th><?php echo e(trans('messages.date_time')); ?></th>
                        <th><?php echo e(trans('messages.user')); ?></th>
                        <th><?php echo e(trans('messages.action')); ?></th>
                        <th><?php echo e(trans('messages.description')); ?></th>
                        <th><?php echo e(trans('messages.model')); ?></th>
                        <th><?php echo e(trans('messages.ip_address')); ?></th>
                        <th><?php echo e(trans('messages.actions')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($log->created_at->format('Y-m-d H:i:s')); ?></td>
                        <td>
                            <?php if($log->user): ?>
                                <a href="<?php echo e(route('users.show', $log->user)); ?>"><?php echo e($log->user->name); ?></a>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($log->action_badge); ?>">
                                <?php echo e(trans('messages.' . $log->action)); ?>

                            </span>
                        </td>
                        <td><?php echo e($log->description); ?></td>
                        <td>
                            <?php if($log->model_type): ?>
                                <small><?php echo e(class_basename($log->model_type)); ?></small>
                                <?php if($log->model_id): ?>
                                    <span class="badge bg-secondary">#<?php echo e($log->model_id); ?></span>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td><small><?php echo e($log->ip_address); ?></small></td>
                        <td>
                            <a href="<?php echo e(route('activity-logs.show', $log)); ?>" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            <?php if(auth()->user()->hasRole('Super Admin')): ?>
                            <form method="POST" action="<?php echo e(route('activity-logs.destroy', $log)); ?>" class="d-inline" onsubmit="return confirm('<?php echo e(trans('messages.confirm_delete')); ?>');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center"><?php echo e(trans('messages.no_activity_logs_found')); ?></td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            <?php echo e($logs->links()); ?>

        </div>
    </div>
</div>

<!-- Clear Logs Modal -->
<?php if(auth()->user()->hasRole('Super Admin')): ?>
<div class="modal fade" id="clearLogsModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo e(trans('messages.clear_logs')); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?php echo e(route('activity-logs.clear')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="date_before" class="form-label"><?php echo e(trans('messages.delete_logs_before')); ?></label>
                        <input type="date" name="date_before" class="form-control" required>
                        <small class="text-muted"><?php echo e(trans('messages.clear_logs_warning')); ?></small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(trans('messages.cancel')); ?></button>
                    <button type="submit" class="btn btn-danger"><?php echo e(trans('messages.clear')); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GestionStock\resources\views/activity-logs/index.blade.php ENDPATH**/ ?>