# دليل التثبيت السريع - Gestock UI Style

## 📋 خطوات التثبيت في مشروع Laravel جديد

### 1️⃣ نسخ الملفات

#### في Linux/Mac:
```bash
# نسخ CSS
cp style/css/custom.css public/css/custom.css

# نسخ JS
cp style/js/custom.js public/js/custom.js

# نسخ Layouts
cp -r style/layouts/* resources/views/layouts/
```

#### في Windows PowerShell:
```powershell
# نسخ CSS
Copy-Item style\css\custom.css public\css\custom.css

# نسخ JS
Copy-Item style\js\custom.js public\js\custom.js

# نسخ Layouts
Copy-Item -Recurse style\layouts\* resources\views\layouts\
```

#### في Windows CMD:
```cmd
copy style\css\custom.css public\css\custom.css
copy style\js\custom.js public\js\custom.js
xcopy style\layouts\* resources\views\layouts\ /E /I
```

### 2️⃣ تثبيت التبعيات

```bash
npm install bootstrap@^5.3.0 jquery@^3.7.0
```

### 3️⃣ إنشاء مجلدات CSS و JS (إذا لم تكن موجودة)

```bash
mkdir -p public/css public/js
```

أو في Windows:
```powershell
New-Item -ItemType Directory -Path "public\css" -Force
New-Item -ItemType Directory -Path "public\js" -Force
```

### 4️⃣ استخدام Layout في صفحة Blade

أنشئ صفحة جديدة في `resources/views/`:

```blade
{{-- resources/views/welcome.blade.php --}}
@extends('layouts.master')

@section('title', 'مرحباً بك')

@section('content')
    <div class="card">
        <div class="card-header">
            <h4>مرحباً بك في المشروع</h4>
        </div>
        <div class="card-body">
            <p>هذه صفحة تجريبية لاختبار التصميم.</p>
        </div>
    </div>
@endsection
```

### 5️⃣ التعديلات المطلوبة

#### تعديل `master.blade.php`:

استبدل الكود الخاص بـ Setting model:

```php
// بدلاً من:
$storeName = \App\Models\Setting::get('store_name', 'Gestion Stock');

// استخدم:
$storeName = config('app.name', 'My Application');
```

#### تعديل `navbar.blade.php`:

- احذف أو علّق Treasury Balance Widget إذا لم يكن مطلوباً
- عدّل Routes حسب routes مشروعك
- عدّل Roles/Permissions حسب نظام الصلاحيات

#### تعديل `sidebar.blade.php`:

- عدّل قائمة القوائم حسب احتياجات مشروعك
- عدّل Routes حسب routes مشروعك
- عدّل Roles/Permissions حسب نظام الصلاحيات

### 6️⃣ اختبار التصميم

1. افتح المتصفح وانتقل إلى الصفحة
2. تأكد من تحميل CSS و JS بشكل صحيح
3. اختبر دعم RTL/LTR
4. اختبر Responsive Design

## ✅ قائمة التحقق

- [ ] تم نسخ `custom.css` إلى `public/css/`
- [ ] تم نسخ `custom.js` إلى `public/js/`
- [ ] تم نسخ Layouts إلى `resources/views/layouts/`
- [ ] تم تثبيت Bootstrap و jQuery
- [ ] تم تعديل `master.blade.php` حسب المشروع
- [ ] تم تعديل `navbar.blade.php` حسب المشروع
- [ ] تم تعديل `sidebar.blade.php` حسب المشروع
- [ ] تم اختبار التصميم في المتصفح

## 🐛 حل المشاكل الشائعة

### المشكلة: CSS لا يظهر
**الحل**: تأكد من:
- وجود الملف في `public/css/custom.css`
- استخدام `asset('css/custom.css')` في master.blade.php
- تشغيل `php artisan serve` أو إعداد Virtual Host بشكل صحيح

### المشكلة: JavaScript لا يعمل
**الحل**: تأكد من:
- وجود الملف في `public/js/custom.js`
- تحميل jQuery قبل custom.js
- فتح Console في المتصفح للتحقق من الأخطاء

### المشكلة: Layout لا يظهر
**الحل**: تأكد من:
- وجود الملفات في `resources/views/layouts/`
- استخدام `@extends('layouts.master')` في الصفحة
- عدم وجود أخطاء في Blade syntax

## 📞 الدعم

إذا واجهت أي مشاكل، راجع ملف `README.md` للحصول على معلومات أكثر تفصيلاً.

