# Gestock UI Style Package

حزمة التصميم المستخدمة في مشروع Gestion Stock - قابلة للاستخدام في مشاريع Laravel أخرى.

## 📁 المكونات

### CSS
- `css/custom.css` - الأنماط المخصصة الرئيسية مع دعم RTL/LTR الكامل

### JavaScript
- `js/custom.js` - السكريبتات المخصصة (تنبيهات، تأكيد حذف، بحث، حذف متعدد، إلخ)

### Layouts (Blade Templates)
- `layouts/master.blade.php` - القالب الرئيسي
- `layouts/partials/navbar.blade.php` - شريط التنقل العلوي
- `layouts/partials/sidebar.blade.php` - القائمة الجانبية

## 📦 التبعيات المطلوبة

### CDN (يتم تحميلها تلقائياً في master.blade.php):
- **Bootstrap 5.3.0** (LTR/RTL) - من jsdelivr CDN
- **Bootstrap Icons 1.11.0** - من jsdelivr CDN
- **Flag Icons 7.2.3** - من jsdelivr CDN
- **Google Fonts** - Cairo (للعربية) & Cabin (للإنجليزية/الفرنسية)
- **jQuery 3.7.0** - من code.jquery.com CDN

### NPM Packages:
```json
{
  "dependencies": {
    "bootstrap": "^5.3.0",
    "jquery": "^3.7.0"
  }
}
```

## 🚀 كيفية الاستخدام في مشروع Laravel جديد

### الخطوة 1: نسخ الملفات

```bash
# نسخ CSS
cp style/css/custom.css public/css/custom.css

# نسخ JS
cp style/js/custom.js public/js/custom.js

# نسخ Layouts
cp -r style/layouts/* resources/views/layouts/
```

أو في Windows PowerShell:
```powershell
Copy-Item style\css\custom.css public\css\custom.css
Copy-Item style\js\custom.js public\js\custom.js
Copy-Item -Recurse style\layouts\* resources\views\layouts\
```

### الخطوة 2: تثبيت التبعيات

```bash
npm install bootstrap@^5.3.0 jquery@^3.7.0
```

### الخطوة 3: استخدام Layout في صفحات Blade

```blade
@extends('layouts.master')

@section('title', 'صفحتي')

@section('content')
    <div class="card">
        <div class="card-body">
            <h1>محتوى الصفحة</h1>
        </div>
    </div>
@endsection
```

### الخطوة 4: التعديلات المطلوبة

عند استخدام هذه الحزمة في مشروع جديد، قد تحتاج لتعديل:

#### في `master.blade.php`:
- تعديل `$storeName`, `$storeLogo`, `$currency` حسب منطق مشروعك
- تعديل Footer حسب معلومات مشروعك

#### في `navbar.blade.php`:
- تعديل Routes حسب routes مشروعك
- تعديل Roles/Permissions حسب نظام الصلاحيات المستخدم
- إزالة أو تعديل Treasury Balance Widget إذا لم يكن مطلوباً

#### في `sidebar.blade.php`:
- تعديل Routes حسب routes مشروعك
- تعديل قائمة القوائم حسب احتياجات مشروعك
- تعديل Roles/Permissions حسب نظام الصلاحيات المستخدم

#### في `custom.js`:
- تعديل API endpoints مثل `/api/products/search` حسب مشروعك
- تعديل Selectors حسب HTML مشروعك

## ✨ المميزات

### CSS Features:
- ✅ دعم كامل لـ RTL/LTR مع تبديل تلقائي
- ✅ خطوط متعددة اللغات (Cairo للعربية، Cabin للإنجليزية/الفرنسية)
- ✅ Sidebar ثابت مع تصميم متجاوب
- ✅ Navbar ثابت في الأعلى
- ✅ أنماط Forms و Buttons و Cards مخصصة
- ✅ Footer مخصص مع معلومات المشروع
- ✅ Media Queries للشاشات الصغيرة

### JavaScript Features:
- ✅ إغلاق تلقائي للتنبيهات بعد 10 ثواني
- ✅ التحقق من نطاق التاريخ (Date Range Validation)
- ✅ تأكيد الحذف (Delete Confirmation)
- ✅ البحث التلقائي للمنتجات (يمكن تخصيصه)
- ✅ حذف متعدد (Bulk Delete) مع Modal
- ✅ Select All functionality

## 🎨 الألوان الرئيسية

- **Primary**: `#0d6efd` (Bootstrap Blue)
- **Sidebar Background**: `#343a40` (Dark Gray)
- **Page Background**: `#f5f5f5` (Light Gray)
- **Success**: `#28a745` (Green)
- **Danger**: `#dc3545` (Red)
- **POS Menu**: `#28a745` (Green)

## 🌍 دعم اللغات

- **العربية** (RTL) - خط Cairo
- **الإنجليزية** (LTR) - خط Cabin
- **الفرنسية** (LTR) - خط Cabin

## 📋 المتطلبات

- Laravel 8.x أو أحدث
- PHP 7.4 أو أحدث
- Node.js و NPM
- Bootstrap 5.3.0
- jQuery 3.7.0

## 📝 ملاحظات مهمة

1. **Routes**: تأكد من أن جميع Routes المستخدمة في layouts موجودة في مشروعك
2. **Translations**: تأكد من وجود ملفات الترجمة في `resources/lang/`
3. **Roles/Permissions**: إذا كنت تستخدم نظام صلاحيات مختلف، قم بتعديل الشروط في navbar و sidebar
4. **Models**: إذا كنت تستخدم `Setting` model، تأكد من وجوده في مشروعك

## 🔧 التخصيص

### تغيير الألوان:
عدّل المتغيرات في `css/custom.css`:
- `.sidebar` - لون القائمة الجانبية
- `.navbar` - لون شريط التنقل
- `.footer-brand` - لون اسم المشروع

### إضافة ميزات JavaScript:
أضف كودك المخصص في `custom.js` أو استخدم `@stack('scripts')` في master.blade.php

### إضافة أنماط CSS:
أضف أنماطك المخصصة في `custom.css` أو استخدم `@stack('styles')` في master.blade.php

## 📄 الترخيص

هذا التصميم جزء من مشروع Gestion Stock.

## 📌 الإصدار

**v3.25.1**

---

**تم التطوير بواسطة ImraneSoft**

