$(document).ready(function() {
    // Auto-dismiss alerts after 10 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 10000);

    // Date range validation - disable end date before start date
    function updateEndDateMin(startDateInput) {
        const startDate = $(startDateInput).val();
        const form = $(startDateInput).closest('form');
        
        // Find corresponding end date input
        let endDateInput = null;
        if ($(startDateInput).attr('name') === 'date_from' || $(startDateInput).attr('id') === 'date_from') {
            endDateInput = form.find('input[name="date_to"], input[id="date_to"]');
        } else if ($(startDateInput).attr('name') === 'start_date' || $(startDateInput).attr('id') === 'start_date') {
            endDateInput = form.find('input[name="end_date"], input[id="end_date"]');
        }
        
        if (startDate && endDateInput && endDateInput.length) {
            endDateInput.attr('min', startDate);
            // If end date is before start date, clear it
            if (endDateInput.val() && endDateInput.val() < startDate) {
                endDateInput.val('');
            }
        }
    }

    // Initialize date range validation on page load
    $('input[type="date"][name="date_from"], input[type="date"][id="date_from"], input[type="date"][name="start_date"], input[type="date"][id="start_date"]').each(function() {
        updateEndDateMin(this);
    });

    // Handle date_from and date_to pairs using event delegation
    $(document).on('change', 'input[type="date"][name="date_from"], input[type="date"][id="date_from"]', function() {
        updateEndDateMin(this);
    });

    // Handle start_date and end_date pairs using event delegation
    $(document).on('change', 'input[type="date"][name="start_date"], input[type="date"][id="start_date"]', function() {
        updateEndDateMin(this);
    });

    // Confirm delete actions - using both jQuery and vanilla JS for compatibility
    $(document).on('submit', '.delete-form', function(e) {
        const message = this.getAttribute('data-confirm') || 'Are you sure you want to delete this item?';
        if (!confirm(message)) {
            e.preventDefault();
            e.stopPropagation();
            return false;
        }
    });

    // Fallback using vanilla JavaScript if jQuery fails
    document.addEventListener('submit', function(e) {
        if (e.target && e.target.classList && e.target.classList.contains('delete-form')) {
            const message = e.target.getAttribute('data-confirm') || 'Are you sure you want to delete this item?';
            if (!confirm(message)) {
                e.preventDefault();
                e.stopPropagation();
                return false;
            }
        }
    });

    // Product search autocomplete
    $('#product-search').on('input', function() {
        const query = $(this).val();
        if (query.length >= 2) {
            $.ajax({
                url: '/api/products/search',
                data: { q: query },
                success: function(products) {
                    // Handle autocomplete results
                    console.log(products);
                }
            });
        }
    });

    // Bulk Delete - Select All functionality
    function initBulkDelete() {
        const selectAll = $('#select-all');
        const itemCheckboxes = $('.item-checkbox');
        const deleteSelectedBtn = $('#delete-selected-btn');
        const bulkDeleteForm = $('#bulk-delete-form');

        // Select All checkbox
        if (selectAll.length) {
            selectAll.on('change', function() {
                itemCheckboxes.prop('checked', $(this).prop('checked'));
                updateDeleteButton();
            });

            // Individual checkboxes
            itemCheckboxes.on('change', function() {
                const allChecked = itemCheckboxes.length === itemCheckboxes.filter(':checked').length;
                selectAll.prop('checked', allChecked);
                updateDeleteButton();
            });

            // Update delete button state
            function updateDeleteButton() {
                const checkedCount = itemCheckboxes.filter(':checked').length;
                if (checkedCount > 0) {
                    deleteSelectedBtn.prop('disabled', false);
                } else {
                    deleteSelectedBtn.prop('disabled', true);
                }
            }

            // Initialize button state
            updateDeleteButton();

            // Delete button click - show modal (Bootstrap 5)
            deleteSelectedBtn.on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                const checkedIds = itemCheckboxes.filter(':checked').map(function() {
                    return $(this).val();
                }).get();

                if (checkedIds.length === 0) {
                    return false;
                }

                // Show confirmation modal (Bootstrap 5)
                const modalElement = document.getElementById('bulkDeleteModal');
                if (modalElement) {
                    // Get or create modal instance
                    let modal = bootstrap.Modal.getInstance(modalElement);
                    if (!modal) {
                        modal = new bootstrap.Modal(modalElement, {
                            backdrop: true,
                            keyboard: true,
                            focus: true
                        });
                    }
                    modal.show();
                }
                return false;
            });

            // Confirm delete in modal
            $(document).off('click', '#confirm-bulk-delete').on('click', '#confirm-bulk-delete', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                const checkedIds = itemCheckboxes.filter(':checked').map(function() {
                    return $(this).val();
                }).get();

                if (checkedIds.length === 0) {
                    const modalElement = document.getElementById('bulkDeleteModal');
                    if (modalElement) {
                        const modal = bootstrap.Modal.getInstance(modalElement);
                        if (modal) modal.hide();
                    }
                    return false;
                }

                // Hide modal first
                const modalElement = document.getElementById('bulkDeleteModal');
                if (modalElement) {
                    const modal = bootstrap.Modal.getInstance(modalElement);
                    if (modal) {
                        modal.hide();
                    }
                }

                // Use the existing form instead of creating a new one
                // Clear any existing hidden inputs
                bulkDeleteForm.find('input[name="selected_ids[]"]').remove();
                
                // Add selected IDs to the form
                checkedIds.forEach(function(id) {
                    const input = $('<input>').attr({
                        type: 'hidden',
                        name: 'selected_ids[]',
                        value: id
                    });
                    bulkDeleteForm.append(input);
                });

                // Submit the form after a small delay to ensure modal is closed
                setTimeout(function() {
                    bulkDeleteForm.submit();
                }, 100);
                
                return false;
            });

            // Handle modal close events to prevent page freezing
            $(document).off('hidden.bs.modal', '#bulkDeleteModal').on('hidden.bs.modal', '#bulkDeleteModal', function() {
                // Clear any pending form submissions
                bulkDeleteForm.find('input[name="selected_ids[]"]').remove();
            });
        }
    }

    // Initialize bulk delete on page load
    initBulkDelete();
});

