@php
    $currentLocale = app()->getLocale();
    $isRTL = $currentLocale === 'ar';
@endphp
<div class="sidebar">
    <ul class="nav flex-column">
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('pos.*') ? 'active' : '' }}" href="{{ route('pos.index') }}">
                <i class="bi bi-cart"></i> <span>{{ trans('messages.pos') }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}" href="{{ route('dashboard') }}">
                <i class="bi bi-speedometer2"></i> <span>{{ trans('messages.dashboard') }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('products.*') ? 'active' : '' }}" href="{{ route('products.index') }}">
                <i class="bi bi-box"></i> <span>{{ trans('messages.products') }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('categories.*') ? 'active' : '' }}" href="{{ route('categories.index') }}">
                <i class="bi bi-tags"></i> <span>{{ trans('messages.categories') }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('invoices.*') ? 'active' : '' }}" href="{{ route('invoices.index') }}">
                <i class="bi bi-receipt"></i> <span>{{ trans('messages.invoices') }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('customers.*') ? 'active' : '' }}" href="{{ route('customers.index') }}">
                <i class="bi bi-people"></i> <span>{{ trans('messages.customers') }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('suppliers.*') ? 'active' : '' }}" href="{{ route('suppliers.index') }}">
                <i class="bi bi-truck"></i> <span>{{ trans('messages.suppliers') }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('purchase-invoices.*') ? 'active' : '' }}" href="{{ route('purchase-invoices.index') }}">
                <i class="bi bi-cart-plus"></i> <span>{{ trans('messages.purchase_invoices') }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('reports.*') ? 'active' : '' }}" href="{{ route('reports.sales') }}">
                <i class="bi bi-graph-up"></i> <span>{{ trans('messages.reports') }}</span>
            </a>
        </li>
        @if(auth()->check() && auth()->user()->hasAnyRole(['Super Admin', 'Admin', 'User']))
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('treasury.*') ? 'active' : '' }}" href="{{ route('treasury.dashboard') }}">
                <i class="bi bi-cash-coin"></i> <span>{{ trans('messages.treasury') }}</span>
            </a>
        </li>
        @endif
        @if(auth()->check() && auth()->user()->hasAnyRole(['Super Admin', 'Admin']))
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('settings.*') ? 'active' : '' }}" href="{{ route('settings.index') }}">
                <i class="bi bi-gear"></i> <span>{{ trans('messages.settings') }}</span>
            </a>
        </li>
        @endif
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('user-guide.*') ? 'active' : '' }}" href="{{ route('user-guide.index') }}">
                <i class="bi bi-book"></i> <span>{{ trans('messages.user_guide') }}</span>
            </a>
        </li>
        @if(auth()->check() && auth()->user()->hasRole('Super Admin'))
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('users.*') ? 'active' : '' }}" href="{{ route('users.index') }}">
                <i class="bi bi-person-gear"></i> <span>{{ trans('messages.users') }}</span>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('backups.*') ? 'active' : '' }}" href="{{ route('backups.index') }}">
                <i class="bi bi-database"></i> <span>{{ trans('messages.database_backup') }}</span>
            </a>
        </li>
        @endif
    </ul>
</div>

